/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.function.TriFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HashJoinP<E0>
extends AbstractProcessor {
    private final List<Function<E0, Object>> keyFns;
    private final List<Map<Object, Object>> lookupTables;
    private final List<Tag> tags;
    private final BiFunction mapToOutputBiFn;
    private final TriFunction mapToOutputTriFn;
    private boolean ordinal0consumed;

    public HashJoinP(@Nonnull List<Function<E0, Object>> keyFns, @Nonnull List<Tag> tags, @Nullable BiFunction mapToOutputBiFn, @Nullable TriFunction mapToOutputTriFn) {
        this.keyFns = HashJoinP.prependNull(keyFns);
        this.lookupTables = HashJoinP.prependNull(Collections.nCopies(keyFns.size(), null));
        this.tags = tags.isEmpty() ? Collections.emptyList() : HashJoinP.prependNull(tags);
        this.mapToOutputBiFn = mapToOutputBiFn;
        this.mapToOutputTriFn = mapToOutputTriFn;
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        assert (!this.ordinal0consumed) : "Edge 0 must have a lower priority than all other edges";
        this.lookupTables.set(ordinal, (Map)item);
        return true;
    }

    @Override
    protected boolean tryProcess0(@Nonnull Object item) {
        Object e0 = item;
        this.ordinal0consumed = true;
        if (this.tags.isEmpty()) {
            Object result = this.keyFns.size() == 2 ? this.mapToOutputBiFn.apply(e0, this.lookupJoined(1, e0)) : this.mapToOutputTriFn.apply(e0, this.lookupJoined(1, e0), this.lookupJoined(2, e0));
            return result == null || this.tryEmit(result);
        }
        ItemsByTag map = new ItemsByTag();
        for (int i = 1; i < this.keyFns.size(); ++i) {
            map.put(this.tags.get(i), this.lookupJoined(i, e0));
        }
        Object result = this.mapToOutputBiFn.apply(e0, map);
        return result == null || this.tryEmit(result);
    }

    @Nullable
    private Object lookupJoined(int ordinal, E0 item) {
        return this.lookupTables.get(ordinal).get(this.keyFns.get(ordinal).apply(item));
    }

    private static <E> List<E> prependNull(List<E> in) {
        ArrayList<Object> result = new ArrayList<Object>(Collections.singletonList(null));
        result.addAll(in);
        return result;
    }
}

