/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

public final class FileSourceBuilder {
    private static final String GLOB_WILDCARD = "*";
    private final String directory;
    private String glob = "*";
    private boolean sharedFileSystem;
    private Charset charset = StandardCharsets.UTF_8;

    FileSourceBuilder(@Nonnull String directory) {
        this.directory = directory;
    }

    public FileSourceBuilder glob(@Nonnull String glob) {
        this.glob = glob;
        return this;
    }

    public FileSourceBuilder sharedFileSystem(boolean sharedFileSystem) {
        this.sharedFileSystem = sharedFileSystem;
        return this;
    }

    public FileSourceBuilder charset(@Nonnull Charset charset) {
        this.charset = charset;
        return this;
    }

    public BatchSource<String> build() {
        return this.build((filename, line) -> line);
    }

    public <T> BatchSource<T> build(DistributedBiFunction<String, String, ? extends T> mapOutputFn) {
        return Sources.batchFromProcessor("filesSource(" + new File(this.directory, this.glob) + ')', SourceProcessors.readFilesP(this.directory, this.charset, this.glob, this.sharedFileSystem, mapOutputFn));
    }

    public StreamSource<String> buildWatcher() {
        return this.buildWatcher((filename, line) -> line);
    }

    public <T> StreamSource<T> buildWatcher(DistributedBiFunction<String, String, ? extends T> mapOutputFn) {
        return Sources.streamFromProcessor("fileWatcherSource(" + this.directory + '/' + this.glob + ')', SourceProcessors.streamFilesP(this.directory, this.charset, this.glob, this.sharedFileSystem, mapOutputFn));
    }
}

