/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.pipeline.SessionWindowDef;
import com.hazelcast.jet.pipeline.SlidingWindowDef;
import javax.annotation.Nonnull;

public interface WindowDefinition {
    @Nonnull
    public WindowKind kind();

    @Nonnull
    public <W extends WindowDefinition> W downcast();

    public long watermarkFrameSize();

    @Nonnull
    public static SlidingWindowDef sliding(long windowSize, long slideBy) {
        return new SlidingWindowDef(windowSize, slideBy);
    }

    @Nonnull
    public static SlidingWindowDef tumbling(long windowSize) {
        return new SlidingWindowDef(windowSize, windowSize);
    }

    @Nonnull
    public static SessionWindowDef session(long sessionTimeout) {
        return new SessionWindowDef(sessionTimeout);
    }

    public static enum WindowKind {
        SLIDING,
        SESSION;

    }
}

