/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.ServicesConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.HazelcastInstanceProxy;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.MetricsConfig;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.config.XmlJetConfigBuilder;
import com.hazelcast.jet.impl.metrics.JetMetricsService;
import com.hazelcast.jet.impl.util.JetGroupProperty;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.merge.IgnoreMergingEntryMapMergePolicy;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Properties;

public final class Jet {
    public static final String INTERNAL_JET_OBJECTS_PREFIX = "__jet.";

    private Jet() {
    }

    public static JetInstance newJetInstance(JetConfig config) {
        Jet.configureJetService(config);
        HazelcastInstanceImpl hazelcastInstance = ((HazelcastInstanceProxy)Hazelcast.newHazelcastInstance(config.getHazelcastConfig())).getOriginal();
        return Util.getJetInstance(hazelcastInstance.node.nodeEngine);
    }

    public static JetInstance newJetInstance() {
        return Jet.newJetInstance(JetConfig.loadDefault());
    }

    public static JetInstance newJetClient() {
        ClientConfig clientConfig = XmlJetConfigBuilder.getClientConfig();
        return Jet.newJetClient(clientConfig);
    }

    public static JetInstance newJetClient(ClientConfig config) {
        return Jet.getJetClientInstance(HazelcastClient.newHazelcastClient(config));
    }

    public static void shutdownAll() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    static JetClientInstanceImpl getJetClientInstance(HazelcastInstance client) {
        return new JetClientInstanceImpl(((HazelcastClientProxy)client).client);
    }

    static void configureJetService(JetConfig jetConfig) {
        Config hzConfig = jetConfig.getHazelcastConfig();
        if (!(hzConfig.getConfigPatternMatcher() instanceof MatchingPointConfigPatternMatcher)) {
            throw new UnsupportedOperationException("Custom config pattern matcher is not supported in Jet");
        }
        Properties jetProps = jetConfig.getProperties();
        Properties hzProperties = hzConfig.getProperties();
        for (String prop : jetProps.stringPropertyNames()) {
            hzProperties.setProperty(prop, jetProps.getProperty(prop));
        }
        HazelcastProperties properties = new HazelcastProperties(hzProperties);
        ServicesConfig servicesConfig = hzConfig.getServicesConfig();
        servicesConfig.addServiceConfig(new ServiceConfig().setEnabled(true).setName("hz:impl:jetService").setClassName(JetService.class.getName()).setProperties(Jet.jetServiceProperties(properties)).setConfigObject(jetConfig));
        servicesConfig.addServiceConfig(new ServiceConfig().setEnabled(true).setName("hz:impl:jetMetricsService").setClassName(JetMetricsService.class.getName()).setConfigObject(jetConfig.getMetricsConfig()));
        MapConfig metadataMapConfig = new MapConfig("__jet.*").setBackupCount(jetConfig.getInstanceConfig().getBackupCount()).setStatisticsEnabled(false).setMergePolicyConfig(new MergePolicyConfig().setPolicy(IgnoreMergingEntryMapMergePolicy.class.getName()));
        MapConfig resultsMapConfig = new MapConfig(metadataMapConfig).setName("__jet.results").setTimeToLiveSeconds(properties.getSeconds(JetGroupProperty.JOB_RESULTS_TTL_SECONDS));
        hzConfig.addMapConfig(metadataMapConfig).addMapConfig(resultsMapConfig);
        MetricsConfig metricsConfig = jetConfig.getMetricsConfig();
        JetMetricsService.applyMetricsConfig(hzConfig, metricsConfig);
        hzConfig.setProperty(GroupProperty.SHUTDOWNHOOK_ENABLED.getName(), "false");
    }

    private static Properties jetServiceProperties(HazelcastProperties hzProperties) {
        Properties properties = new Properties();
        properties.setProperty(GroupProperty.SHUTDOWNHOOK_ENABLED.getName(), hzProperties.getString(GroupProperty.SHUTDOWNHOOK_ENABLED));
        return properties;
    }
}

