/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.security.Credentials;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.StringUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class ClientConfigXmlGenerator {
    private static final ILogger LOGGER = Logger.getLogger(ClientConfigXmlGenerator.class);
    private static final int CAPACITY = 64;

    private ClientConfigXmlGenerator() {
    }

    public static String generate(ClientConfig clientConfig) {
        return ClientConfigXmlGenerator.generate(clientConfig, -1);
    }

    public static String generate(ClientConfig clientConfig, int indent) {
        Preconditions.isNotNull(clientConfig, "ClientConfig");
        StringBuilder xml = new StringBuilder();
        XmlGenerator gen = new XmlGenerator(xml);
        gen.open("hazelcast-client", "xmlns", "http://www.hazelcast.com/schema/client-config", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.hazelcast.com/schema/client-config http://www.hazelcast.com/schema/client-config/hazelcast-client-config-3.10.xsd");
        ClientConfigXmlGenerator.group(gen, clientConfig.getGroupConfig());
        gen.node("instance-name", clientConfig.getInstanceName(), new Object[0]);
        gen.appendProperties(clientConfig.getProperties());
        ClientConfigXmlGenerator.network(gen, clientConfig.getNetworkConfig());
        if (clientConfig.getExecutorPoolSize() > 0) {
            gen.node("executor-pool-size", clientConfig.getExecutorPoolSize(), new Object[0]);
        }
        ClientConfigXmlGenerator.security(gen, clientConfig.getSecurityConfig());
        ClientConfigXmlGenerator.listener(gen, clientConfig.getListenerConfigs());
        ClientConfigXmlGenerator.serialization(gen, clientConfig.getSerializationConfig());
        ClientConfigXmlGenerator.nativeMemory(gen, clientConfig.getNativeMemoryConfig());
        ClientConfigXmlGenerator.proxyFactory(gen, clientConfig.getProxyFactoryConfigs());
        ClientConfigXmlGenerator.loadBalancer(gen, clientConfig.getLoadBalancer());
        ClientConfigXmlGenerator.nearCaches(gen, clientConfig.getNearCacheConfigMap());
        ClientConfigXmlGenerator.queryCaches(gen, clientConfig.getQueryCacheConfigs());
        ClientConnectionStrategyConfig connectionStrategy = clientConfig.getConnectionStrategyConfig();
        gen.node("connection-strategy", null, new Object[]{"async-start", connectionStrategy.isAsyncStart(), "reconnect-mode", connectionStrategy.getReconnectMode()});
        ClientConfigXmlGenerator.userCodeDeployment(gen, clientConfig.getUserCodeDeploymentConfig());
        ClientConfigXmlGenerator.flakeIdGenerator(gen, clientConfig.getFlakeIdGeneratorConfigMap());
        gen.close();
        return ClientConfigXmlGenerator.format(xml.toString(), indent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(String input, int indent) {
        if (indent < 0) {
            return input;
        }
        if (indent == 0) {
            throw new IllegalArgumentException("Indent should be greater than 0");
        }
        StreamResult xmlOutput = null;
        try {
            Transformer transformer;
            StreamSource xmlInput;
            block13: {
                TransformerFactory transformerFactory;
                block12: {
                    xmlInput = new StreamSource(new StringReader(input));
                    xmlOutput = new StreamResult(new StringWriter());
                    transformerFactory = TransformerFactory.newInstance();
                    try {
                        transformerFactory.setAttribute("indent-number", indent);
                    }
                    catch (IllegalArgumentException e) {
                        if (!LOGGER.isFinestEnabled()) break block12;
                        LOGGER.finest("Failed to set indent-number attribute; cause: " + e.getMessage());
                    }
                }
                transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
                }
                catch (IllegalArgumentException e) {
                    if (!LOGGER.isFinestEnabled()) break block13;
                    LOGGER.finest("Failed to set indent-amount property; cause: " + e.getMessage());
                }
            }
            transformer.transform(xmlInput, xmlOutput);
            String string = xmlOutput.getWriter().toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.warning(e);
            String string = input;
            return string;
        }
        finally {
            if (xmlOutput != null) {
                IOUtil.closeResource(xmlOutput.getWriter());
            }
        }
    }

    private static void group(XmlGenerator gen, GroupConfig group) {
        gen.open("group", new Object[0]).node("name", group.getName(), new Object[0]).node("password", group.getPassword(), new Object[0]).close();
    }

    private static void network(XmlGenerator gen, ClientNetworkConfig network) {
        gen.open("network", new Object[0]).node("smart-routing", network.isSmartRouting(), new Object[0]).node("redo-operation", network.isRedoOperation(), new Object[0]).node("connection-timeout", network.getConnectionTimeout(), new Object[0]).node("connection-attempt-period", network.getConnectionAttemptPeriod(), new Object[0]);
        if (network.getConnectionAttemptLimit() >= 0) {
            gen.node("connection-attempt-limit", network.getConnectionAttemptLimit(), new Object[0]);
        }
        ClientConfigXmlGenerator.clusterMembers(gen, network.getAddresses());
        ClientConfigXmlGenerator.socketOptions(gen, network.getSocketOptions());
        ClientConfigXmlGenerator.socketInterceptor(gen, network.getSocketInterceptorConfig());
        ClientConfigXmlGenerator.ssl(gen, network.getSSLConfig());
        ClientConfigXmlGenerator.aws(gen, network.getAwsConfig());
        ClientConfigXmlGenerator.discovery(gen, network.getDiscoveryConfig());
        ClientConfigXmlGenerator.outboundPort(gen, network.getOutboundPortDefinitions());
        ClientConfigXmlGenerator.icmp(gen, network.getClientIcmpPingConfig());
        gen.close();
    }

    private static void security(XmlGenerator gen, ClientSecurityConfig security) {
        String credentialsClassname = security.getCredentialsClassname();
        Credentials credentials = security.getCredentials();
        if (credentialsClassname == null && credentials == null) {
            return;
        }
        gen.open("security", new Object[0]).node("credentials", ClientConfigXmlGenerator.classNameOrImplClass(credentialsClassname, credentials), new Object[0]).close();
    }

    private static void listener(XmlGenerator gen, List<ListenerConfig> listeners) {
        if (listeners.isEmpty()) {
            return;
        }
        gen.open("listeners", new Object[0]);
        listeners.forEach(listener -> gen.node("listener", ClientConfigXmlGenerator.classNameOrImplClass(listener.getClassName(), listener.getImplementation()), new Object[0]));
        gen.close();
    }

    private static void serialization(XmlGenerator gen, SerializationConfig serialization) {
        gen.open("serialization", new Object[0]).node("portable-version", serialization.getPortableVersion(), new Object[0]).node("use-native-byte-order", serialization.isUseNativeByteOrder(), new Object[0]).node("byte-order", serialization.getByteOrder(), new Object[0]).node("enable-compression", serialization.isEnableCompression(), new Object[0]).node("enable-shared-object", serialization.isEnableSharedObject(), new Object[0]).node("allow-unsafe", serialization.isAllowUnsafe(), new Object[0]).node("check-class-def-errors", serialization.isCheckClassDefErrors(), new Object[0]);
        Map<Integer, String> dsfClasses = serialization.getDataSerializableFactoryClasses();
        Map<Integer, DataSerializableFactory> dsfImpls = serialization.getDataSerializableFactories();
        if (!dsfClasses.isEmpty() || !dsfImpls.isEmpty()) {
            gen.open("data-serializable-factories", new Object[0]);
            dsfClasses.forEach((id, className) -> gen.node("data-serializable-factory", className, "factory-id", id));
            dsfImpls.forEach((id, factory) -> gen.node("data-serializable-factory", factory.getClass().getName(), "factory-id", id));
            gen.close();
        }
        Map<Integer, String> portableClasses = serialization.getPortableFactoryClasses();
        Map<Integer, PortableFactory> portableImpls = serialization.getPortableFactories();
        if (!portableClasses.isEmpty() || !portableImpls.isEmpty()) {
            gen.open("portable-factories", new Object[0]);
            portableClasses.forEach((id, className) -> gen.node("portable-factory", className, "factory-id", id));
            portableImpls.forEach((id, factory) -> gen.node("portable-factory", factory.getClass().getName(), "factory-id", id));
            gen.close();
        }
        ClientConfigXmlGenerator.serializers(gen, serialization);
        gen.close();
    }

    private static void serializers(XmlGenerator gen, SerializationConfig serialization) {
        GlobalSerializerConfig global = serialization.getGlobalSerializerConfig();
        Collection<SerializerConfig> serializers = serialization.getSerializerConfigs();
        if (global != null || !serializers.isEmpty()) {
            gen.open("serializers", new Object[0]);
            if (global != null) {
                gen.node("global-serializer", ClientConfigXmlGenerator.classNameOrImplClass(global.getClassName(), global.getImplementation()), "override-java-serialization", global.isOverrideJavaSerialization());
            }
            serializers.forEach(serializer -> gen.node("serializer", null, "type-class", ClientConfigXmlGenerator.classNameOrImplClass(serializer.getTypeClassName(), serializer.getTypeClass()), "class-name", ClientConfigXmlGenerator.classNameOrImplClass(serializer.getClassName(), serializer.getImplementation())));
            gen.close();
        }
    }

    private static void nativeMemory(XmlGenerator gen, NativeMemoryConfig nativeMemory) {
        gen.open("native-memory", new Object[]{"enabled", nativeMemory.isEnabled(), "allocator-type", nativeMemory.getAllocatorType()}).node("size", null, new Object[]{"value", nativeMemory.getSize().getValue(), "unit", nativeMemory.getSize().getUnit()}).node("min-block-size", nativeMemory.getMinBlockSize(), new Object[0]).node("page-size", nativeMemory.getPageSize(), new Object[0]).node("metadata-space-percentage", Float.valueOf(nativeMemory.getMetadataSpacePercentage()), new Object[0]).close();
    }

    private static void proxyFactory(XmlGenerator gen, List<ProxyFactoryConfig> proxyFactories) {
        if (proxyFactories.isEmpty()) {
            return;
        }
        gen.open("proxy-factories", new Object[0]);
        proxyFactories.forEach(proxyFactory -> gen.node("proxy-factory", null, "class-name", ClientConfigXmlGenerator.classNameOrImplClass(proxyFactory.getClassName(), proxyFactory.getFactoryImpl()), "service", proxyFactory.getService()));
        gen.close();
    }

    private static void loadBalancer(XmlGenerator gen, LoadBalancer loadBalancer) {
        String type;
        if (loadBalancer == null) {
            return;
        }
        if (loadBalancer instanceof RandomLB) {
            type = "random";
        } else if (loadBalancer instanceof RoundRobinLB) {
            type = "round-robin";
        } else {
            throw new IllegalArgumentException("Unknown load-balancer type: " + loadBalancer);
        }
        gen.node("load-balancer", null, "type", type);
    }

    private static void nearCaches(XmlGenerator gen, Map<String, NearCacheConfig> nearCacheMap) {
        if (nearCacheMap.isEmpty()) {
            return;
        }
        nearCacheMap.forEach((name, nearCache) -> ClientConfigXmlGenerator.nearCache(gen, name, nearCache));
    }

    private static void queryCaches(XmlGenerator gen, Map<String, Map<String, QueryCacheConfig>> queryCaches) {
        if (queryCaches.isEmpty()) {
            return;
        }
        gen.open("query-caches", new Object[0]);
        queryCaches.forEach((mapName, queryCachesPerMap) -> queryCachesPerMap.forEach((name, queryCache) -> {
            gen.open("query-cache", "mapName", mapName, "name", queryCache.getName()).node("include-value", queryCache.isIncludeValue(), new Object[0]).node("in-memory-format", (Object)queryCache.getInMemoryFormat(), new Object[0]).node("populate", queryCache.isPopulate(), new Object[0]).node("coalesce", queryCache.isCoalesce(), new Object[0]).node("delay-seconds", queryCache.getDelaySeconds(), new Object[0]).node("batch-size", queryCache.getBatchSize(), new Object[0]).node("buffer-size", queryCache.getBufferSize(), new Object[0]).node("eviction", null, new Object[]{"size", queryCache.getEvictionConfig().getSize(), "max-size-policy", queryCache.getEvictionConfig().getMaximumSizePolicy(), "eviction-policy", queryCache.getEvictionConfig().getEvictionPolicy()});
            ClientConfigXmlGenerator.queryCachePredicate(gen, queryCache.getPredicateConfig());
            ClientConfigXmlGenerator.entryListeners(gen, queryCache.getEntryListenerConfigs());
            ClientConfigXmlGenerator.indexes(gen, queryCache.getIndexConfigs());
            gen.close();
        }));
        gen.close();
    }

    private static void userCodeDeployment(XmlGenerator gen, ClientUserCodeDeploymentConfig userCodeDeployment) {
        List<String> jarPaths;
        gen.open("user-code-deployment", "enabled", userCodeDeployment.isEnabled());
        List<String> classNames = userCodeDeployment.getClassNames();
        if (!classNames.isEmpty()) {
            gen.open("classNames", new Object[0]);
            classNames.forEach(className -> gen.node("className", className, new Object[0]));
            gen.close();
        }
        if (!(jarPaths = userCodeDeployment.getJarPaths()).isEmpty()) {
            gen.open("jarPaths", new Object[0]);
            jarPaths.forEach(jarPath -> gen.node("jarPath", jarPath, new Object[0]));
            gen.close();
        }
        gen.close();
    }

    private static void flakeIdGenerator(XmlGenerator gen, Map<String, ClientFlakeIdGeneratorConfig> flakeIdGenerators) {
        flakeIdGenerators.forEach((name, flakeIdGenerator) -> gen.open("flake-id-generator", "name", name).node("prefetch-count", flakeIdGenerator.getPrefetchCount(), new Object[0]).node("prefetch-validity-millis", flakeIdGenerator.getPrefetchValidityMillis(), new Object[0]).close());
    }

    private static void indexes(XmlGenerator gen, List<MapIndexConfig> indexes) {
        if (indexes.isEmpty()) {
            return;
        }
        gen.open("indexes", new Object[0]);
        indexes.forEach(index -> gen.node("index", index.getAttribute(), "ordered", index.isOrdered()));
        gen.close();
    }

    private static void entryListeners(XmlGenerator gen, List<EntryListenerConfig> entryListeners) {
        if (entryListeners.isEmpty()) {
            return;
        }
        gen.open("entry-listeners", new Object[0]);
        entryListeners.forEach(listener -> gen.node("entry-listener", ClientConfigXmlGenerator.classNameOrImplClass(listener.getClassName(), listener.getImplementation()), "include-value", listener.isIncludeValue(), "local", listener.isLocal()));
        gen.close();
    }

    private static void queryCachePredicate(XmlGenerator gen, PredicateConfig predicate) {
        String sql = predicate.getSql();
        String content = sql != null ? sql : ClientConfigXmlGenerator.classNameOrImplClass(predicate.getClassName(), predicate.getImplementation());
        String type = sql != null ? "sql" : "class-name";
        gen.node("predicate", content, "type", type);
    }

    private static void clusterMembers(XmlGenerator gen, List<String> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            return;
        }
        gen.open("cluster-members", new Object[0]);
        addresses.forEach(address -> gen.node("address", address, new Object[0]));
        gen.close();
    }

    private static void socketOptions(XmlGenerator gen, SocketOptions socketOptions) {
        gen.open("socket-options", new Object[0]).node("tcp-no-delay", socketOptions.isTcpNoDelay(), new Object[0]).node("keep-alive", socketOptions.isKeepAlive(), new Object[0]).node("reuse-address", socketOptions.isReuseAddress(), new Object[0]).node("linger-seconds", socketOptions.getLingerSeconds(), new Object[0]).node("buffer-size", socketOptions.getBufferSize(), new Object[0]).close();
    }

    private static void socketInterceptor(XmlGenerator gen, SocketInterceptorConfig socketInterceptor) {
        if (socketInterceptor == null) {
            return;
        }
        gen.open("socket-interceptor", "enabled", socketInterceptor.isEnabled()).node("class-name", ClientConfigXmlGenerator.classNameOrImplClass(socketInterceptor.getClassName(), socketInterceptor.getImplementation()), new Object[0]).appendProperties(socketInterceptor.getProperties()).close();
    }

    private static void ssl(XmlGenerator gen, SSLConfig ssl) {
        if (ssl == null) {
            return;
        }
        gen.open("ssl", "enabled", ssl.isEnabled()).node("factory-class-name", ClientConfigXmlGenerator.classNameOrImplClass(ssl.getFactoryClassName(), ssl.getFactoryImplementation()), new Object[0]).appendProperties(ssl.getProperties()).close();
    }

    private static void aws(XmlGenerator gen, ClientAwsConfig aws) {
        if (aws == null) {
            return;
        }
        gen.open("aws", "enabled", aws.isEnabled(), "connection-timeout-seconds", aws.getConnectionTimeoutSeconds()).node("inside-aws", aws.isInsideAws(), new Object[0]).node("access-key", aws.getAccessKey(), new Object[0]).node("secret-key", aws.getSecretKey(), new Object[0]).node("iam-role", aws.getIamRole(), new Object[0]).node("region", aws.getRegion(), new Object[0]).node("host-header", aws.getHostHeader(), new Object[0]).node("security-group-name", aws.getSecurityGroupName(), new Object[0]).node("tag-key", aws.getTagKey(), new Object[0]).node("tag-value", aws.getTagValue(), new Object[0]).close();
    }

    private static void discovery(XmlGenerator gen, DiscoveryConfig discovery) {
        if (discovery.getNodeFilter() == null && discovery.getNodeFilterClass() == null && discovery.getDiscoveryStrategyConfigs().isEmpty()) {
            return;
        }
        gen.open("discovery-strategies", new Object[0]).node("node-filter", null, "class", ClientConfigXmlGenerator.classNameOrImplClass(discovery.getNodeFilterClass(), discovery.getNodeFilter()));
        discovery.getDiscoveryStrategyConfigs().forEach(strategy -> gen.open("discovery-strategy", "class", strategy.getClassName(), "enabled", true).appendProperties(strategy.getProperties()).close());
        gen.close();
    }

    private static void outboundPort(XmlGenerator gen, Collection<String> outboundPortDefinitions) {
        if (outboundPortDefinitions != null && !outboundPortDefinitions.isEmpty()) {
            gen.open("outbound-ports", new Object[0]);
            outboundPortDefinitions.forEach(portDefinitions -> gen.node("ports", portDefinitions, new Object[0]));
            gen.close();
        }
    }

    private static void icmp(XmlGenerator gen, ClientIcmpPingConfig icmp) {
        gen.open("icmp-ping", "enabled", icmp.isEnabled()).node("timeout-milliseconds", icmp.getTimeoutMilliseconds(), new Object[0]).node("interval-milliseconds", icmp.getIntervalMilliseconds(), new Object[0]).node("ttl", icmp.getTtl(), new Object[0]).node("max-attempts", icmp.getMaxAttempts(), new Object[0]).node("echo-fail-fast-on-startup", icmp.isEchoFailFastOnStartup(), new Object[0]).close();
    }

    private static void nearCache(XmlGenerator gen, String name, NearCacheConfig nearCache) {
        EvictionConfig eviction = nearCache.getEvictionConfig();
        NearCachePreloaderConfig preloader = nearCache.getPreloaderConfig();
        gen.open("near-cache", "name", name).node("in-memory-format", (Object)nearCache.getInMemoryFormat(), new Object[0]).node("serialize-keys", nearCache.isSerializeKeys(), new Object[0]).node("invalidate-on-change", nearCache.isInvalidateOnChange(), new Object[0]).node("cache-local-entries", nearCache.isCacheLocalEntries(), new Object[0]).node("time-to-live-seconds", nearCache.getTimeToLiveSeconds(), new Object[0]).node("max-idle-seconds", nearCache.getMaxIdleSeconds(), new Object[0]).node("local-update-policy", (Object)nearCache.getLocalUpdatePolicy(), new Object[0]).node("eviction", null, new Object[]{"size", eviction.getSize(), "max-size-policy", eviction.getMaximumSizePolicy(), "eviction-policy", eviction.getEvictionPolicy()}).node("preloader", null, "enabled", preloader.isEnabled(), "directory", preloader.getDirectory(), "store-initial-delay-seconds", preloader.getStoreInitialDelaySeconds(), "store-interval-seconds", preloader.getStoreIntervalSeconds());
        gen.close();
    }

    private static String classNameOrImplClass(String className, Object impl) {
        return !StringUtil.isNullOrEmpty(className) ? className : (impl != null ? impl.getClass().getName() : null);
    }

    private static final class XmlGenerator {
        private final StringBuilder xml;
        private final ArrayDeque<String> openNodes = new ArrayDeque();

        private XmlGenerator(StringBuilder xml) {
            this.xml = xml;
        }

        XmlGenerator open(String name, Object ... attributes) {
            XmlGenerator.appendOpenNode(this.xml, name, attributes);
            this.openNodes.addLast(name);
            return this;
        }

        XmlGenerator node(String name, Object contents, Object ... attributes) {
            XmlGenerator.appendNode(this.xml, name, contents, attributes);
            return this;
        }

        XmlGenerator close() {
            XmlGenerator.appendCloseNode(this.xml, this.openNodes.pollLast());
            return this;
        }

        XmlGenerator appendProperties(Properties props) {
            if (!props.isEmpty()) {
                this.open("properties", new Object[0]);
                Set<Object> keys = props.keySet();
                for (Object key : keys) {
                    this.node("property", props.getProperty(key.toString()), "name", key.toString());
                }
                this.close();
            }
            return this;
        }

        XmlGenerator appendProperties(Map<String, Comparable> props) {
            if (!MapUtil.isNullOrEmpty(props)) {
                this.open("properties", new Object[0]);
                for (Map.Entry<String, Comparable> entry : props.entrySet()) {
                    this.node("property", entry.getValue(), "name", entry.getKey());
                }
                this.close();
            }
            return this;
        }

        private static void appendOpenNode(StringBuilder xml, String name, Object ... attributes) {
            xml.append('<').append(name);
            XmlGenerator.appendAttributes(xml, attributes);
            xml.append('>');
        }

        private static void appendCloseNode(StringBuilder xml, String name) {
            xml.append("</").append(name).append('>');
        }

        private static void appendNode(StringBuilder xml, String name, Object contents, Object ... attributes) {
            if (contents != null || attributes.length > 0) {
                xml.append('<').append(name);
                XmlGenerator.appendAttributes(xml, attributes);
                if (contents != null) {
                    xml.append('>');
                    XmlGenerator.escapeXml(contents, xml);
                    xml.append("</").append(name).append('>');
                } else {
                    xml.append("/>");
                }
            }
        }

        private static void appendAttributes(StringBuilder xml, Object ... attributes) {
            int i = 0;
            while (i < attributes.length) {
                xml.append(" ").append(attributes[i++]).append("=\"");
                XmlGenerator.escapeXmlAttr(attributes[i++], xml);
                xml.append("\"");
            }
        }

        private static void escapeXml(Object o, StringBuilder appendTo) {
            if (o == null) {
                appendTo.append("null");
                return;
            }
            String s = o.toString();
            int length = s.length();
            appendTo.ensureCapacity(appendTo.length() + length + 64);
            for (int i = 0; i < length; ++i) {
                char ch = s.charAt(i);
                if (ch == '<') {
                    appendTo.append("&lt;");
                    continue;
                }
                if (ch == '&') {
                    appendTo.append("&amp;");
                    continue;
                }
                appendTo.append(ch);
            }
        }

        private static void escapeXmlAttr(Object o, StringBuilder appendTo) {
            if (o == null) {
                appendTo.append("null");
                return;
            }
            String s = o.toString();
            int length = s.length();
            appendTo.ensureCapacity(appendTo.length() + length + 64);
            block6: for (int i = 0; i < length; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        appendTo.append("&quot;");
                        continue block6;
                    }
                    case '\'': {
                        appendTo.append("&#39;");
                        continue block6;
                    }
                    case '&': {
                        appendTo.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        appendTo.append("&lt;");
                        continue block6;
                    }
                    default: {
                        appendTo.append(ch);
                    }
                }
            }
        }
    }
}

