/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.function;

import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface DistributedPredicate<T>
extends Predicate<T>,
Serializable {
    public boolean testEx(T var1) throws Exception;

    @Override
    default public boolean test(T t) {
        try {
            return this.testEx(t);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Nonnull
    public static <T> DistributedPredicate<T> alwaysTrue() {
        return t -> true;
    }

    @Nonnull
    public static <T> DistributedPredicate<T> alwaysFalse() {
        return t -> false;
    }

    @Nonnull
    public static <T> DistributedPredicate<T> isEqual(Object other) {
        return other == null ? Objects::isNull : other::equals;
    }

    @Override
    @Nonnull
    default public DistributedPredicate<T> and(DistributedPredicate<? super T> other) {
        Preconditions.checkNotNull(other, "other");
        return t -> this.test(t) && other.test(t);
    }

    @Override
    @Nonnull
    default public DistributedPredicate<T> negate() {
        return t -> !this.test(t);
    }

    @Override
    @Nonnull
    default public DistributedPredicate<T> or(DistributedPredicate<? super T> other) {
        Preconditions.checkNotNull(other, "other");
        return t -> this.test(t) || other.test(t);
    }
}

