/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.aggregation.impl.MaxByAggregator;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.impl.execution.SnapshotRecord;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.query.Predicate;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SnapshotRepository {
    public static final String SNAPSHOT_NAME_PREFIX = "__jet.snapshots.";
    public static final String SNAPSHOT_DATA_NAME_PREFIX = "__jet.snapshots.data.";
    private static final long LATEST_STARTED_SNAPSHOT_ID_KEY = -1L;
    private static final Comparator<SnapshotRecord> SNAPSHOT_RECORD_COMPARATOR = Comparator.comparing(SnapshotRecord::getId).reversed();
    private final JetInstance instance;
    private final ILogger logger;

    public SnapshotRepository(JetInstance jetInstance) {
        this.instance = jetInstance;
        this.logger = jetInstance.getHazelcastInstance().getLoggingService().getLogger(this.getClass());
    }

    long registerSnapshot(long jobId, Collection<String> vertexNames) {
        long nextSnapshotId;
        SnapshotRecord record;
        IMap<Long, Object> snapshots = this.getSnapshotMap(jobId);
        while (snapshots.putIfAbsent((record = new SnapshotRecord(jobId, nextSnapshotId = this.generateNextSnapshotId(snapshots), vertexNames)).snapshotId(), record) != null) {
        }
        return record.snapshotId();
    }

    private long generateNextSnapshotId(IMap<Long, Object> snapshots) {
        long nextSnapshotId;
        Long snapshotId;
        do {
            long l = nextSnapshotId = (snapshotId = (Long)snapshots.get(-1L)) == null ? 0L : snapshotId + 1L;
        } while (!SnapshotRepository.replaceAllowingNull(snapshots, -1L, snapshotId, nextSnapshotId));
        return nextSnapshotId;
    }

    private static <K, V> boolean replaceAllowingNull(IMap<K, V> map, K key, V oldValue, V newValue) {
        if (oldValue == null) {
            return map.putIfAbsent(key, newValue) == null;
        }
        return map.replace(key, oldValue, newValue);
    }

    long setSnapshotComplete(long jobId, long snapshotId, SnapshotRecord.SnapshotStatus status, long numBytes, long numKeys, long numChunks) {
        IMap snapshots = this.getSnapshotMap(jobId);
        SnapshotRecord record = Util.compute(snapshots, snapshotId, (k, r) -> {
            if (r == null) {
                return null;
            }
            r.snapshotComplete(status, numBytes, numKeys, numChunks);
            return r;
        });
        if (record == null) {
            this.logger.fine("Not marking SnapshotRecord as complete, already deleted");
            return -1L;
        }
        return System.currentTimeMillis() - record.startTime();
    }

    @Nullable
    Long latestCompleteSnapshot(long jobId) {
        Predicate completedSnapshots;
        MaxByAggregator<Map.Entry<Long, Object>> entryMaxByAggregator;
        IMap snapshotMap = this.getSnapshotMap(jobId);
        Map.Entry entry = (Map.Entry)snapshotMap.aggregate(entryMaxByAggregator = this.maxByAggregator(), completedSnapshots = e -> {
            Object value = e.getValue();
            return value instanceof SnapshotRecord && ((SnapshotRecord)value).isSuccessful();
        });
        return entry != null ? (Long)entry.getKey() : null;
    }

    @Nullable
    Long latestStartedSnapshot(long jobId) {
        IMap map = this.getSnapshotMap(jobId);
        return (Long)map.get(-1L);
    }

    public <T> IMap<Long, T> getSnapshotMap(long jobId) {
        return this.instance.getHazelcastInstance().getMap(SnapshotRepository.snapshotsMapName(jobId));
    }

    public List<SnapshotRecord> getAllSnapshotRecords(long jobId) {
        return this.getSnapshotMap(jobId).values().stream().filter(v -> v instanceof SnapshotRecord).map(v -> (SnapshotRecord)v).sorted(SNAPSHOT_RECORD_COMPARATOR).collect(Collectors.toList());
    }

    private MaxByAggregator<Map.Entry<Long, Object>> maxByAggregator() {
        return new MaxByAggregator<Map.Entry<Long, Object>>("snapshotId");
    }

    public static String snapshotsMapName(long jobId) {
        return SNAPSHOT_NAME_PREFIX + com.hazelcast.jet.Util.idToString(jobId);
    }

    public static String snapshotDataMapName(long jobId, long snapshotId, String vertexName) {
        return SNAPSHOT_DATA_NAME_PREFIX + com.hazelcast.jet.Util.idToString(jobId) + '.' + snapshotId + '.' + vertexName;
    }

    void deleteAllSnapshotsExceptOne(long jobId, Long snapshotToKeep) {
        IMap<Long, SnapshotRecord> snapshotMap = this.getSnapshotMap(jobId);
        Predicate predicate = e -> !((Long)e.getKey()).equals(-1L) && !((Long)e.getKey()).equals(snapshotToKeep);
        for (Map.Entry entry : snapshotMap.entrySet(predicate)) {
            this.deleteSnapshot(snapshotMap, (SnapshotRecord)entry.getValue());
        }
    }

    void deleteSingleSnapshot(long jobId, Long snapshotId) {
        IMap<Long, SnapshotRecord> snapshotMap = this.getSnapshotMap(jobId);
        SnapshotRecord record = (SnapshotRecord)snapshotMap.get(snapshotId);
        if (record != null) {
            this.deleteSnapshot(snapshotMap, record);
        }
    }

    void deleteAllSnapshots(long jobId) {
        IMap snapshotMap = this.getSnapshotMap(jobId);
        Predicate predicate = e -> !e.getKey().equals(-1L);
        for (Map.Entry entry : snapshotMap.entrySet(predicate)) {
            this.deleteSnapshotData((SnapshotRecord)entry.getValue());
        }
        LoggingUtil.logFine(this.logger, "Deleted all snapshots for job %s", com.hazelcast.jet.Util.idToString(jobId));
        snapshotMap.destroy();
    }

    void deleteSnapshot(IMap<Long, SnapshotRecord> map, SnapshotRecord record) {
        IMap snapshots = this.getSnapshotMap(record.jobId());
        Util.compute(snapshots, record.snapshotId(), (k, r) -> {
            if (r != null) {
                r.setStatus(SnapshotRecord.SnapshotStatus.TO_DELETE);
            }
            return r;
        });
        this.deleteSnapshotData(record);
        map.remove(record.snapshotId());
        LoggingUtil.logFinest(this.logger, "Deleted snapshot record for snapshot %d for job %s", record.snapshotId(), com.hazelcast.jet.Util.idToString(record.jobId()));
    }

    private void deleteSnapshotData(SnapshotRecord record) {
        for (String vertexName : record.vertices()) {
            String mapName = SnapshotRepository.snapshotDataMapName(record.jobId(), record.snapshotId(), vertexName);
            this.instance.getMap(mapName).destroy();
            LoggingUtil.logFine(this.logger, "Deleted snapshot data for snapshot %d for job %s and vertex '%s'", record.snapshotId(), com.hazelcast.jet.Util.idToString(record.jobId()), vertexName);
        }
    }
}

