/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class AbstractTransform
implements Transform {
    @Nonnull
    private String name;
    @Nonnull
    private final List<Transform> upstream;
    @Nonnull
    private Optimization optimization = Optimization.NETWORK_TRAFFIC;
    private int localParallelism = -1;

    protected AbstractTransform(@Nonnull String name, @Nonnull List<Transform> upstream) {
        this.name = name;
        this.upstream = upstream;
    }

    protected AbstractTransform(String name, @Nonnull Transform upstream) {
        this(name, Collections.singletonList(upstream));
    }

    @Override
    @Nonnull
    public List<Transform> upstream() {
        return this.upstream;
    }

    @Override
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    @Override
    @Nonnull
    public String name() {
        return this.name;
    }

    @Override
    public void localParallelism(int localParallelism) {
        this.localParallelism = Vertex.checkLocalParallelism(localParallelism);
    }

    @Override
    public int localParallelism() {
        return this.localParallelism;
    }

    @Nonnull
    Optimization getOptimization() {
        return this.optimization;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public long watermarkFrameSize() {
        return 0L;
    }

    public static enum Optimization {
        NETWORK_TRAFFIC,
        MEMORY;

    }
}

