/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Traverser;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class Traversers {
    private Traversers() {
    }

    @Nonnull
    public static <T> Traverser<T> empty() {
        return () -> null;
    }

    @Nonnull
    public static <T> Traverser<T> singleton(@Nonnull T item) {
        return new SingletonTraverser<T>(item);
    }

    @Nonnull
    public static <T> Traverser<T> traverseIterator(@Nonnull Iterator<? extends T> iterator) {
        return () -> iterator.hasNext() ? Objects.requireNonNull(iterator.next(), "Iterator returned a null item") : null;
    }

    @Nonnull
    public static <T> Traverser<T> traverseIterator(@Nonnull Iterator<? extends T> iterator, boolean ignoreNulls) {
        if (!ignoreNulls) {
            return Traversers.traverseIterator(iterator);
        }
        return () -> {
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next == null) continue;
                return next;
            }
            return null;
        };
    }

    @Nonnull
    public static <T> Traverser<T> traverseSpliterator(@Nonnull Spliterator<T> spliterator) {
        return new SpliteratorTraverser<T>(spliterator);
    }

    @Nonnull
    public static <T> Traverser<T> traverseEnumeration(@Nonnull Enumeration<T> enumeration) {
        return () -> enumeration.hasMoreElements() ? Objects.requireNonNull(enumeration.nextElement(), "Enumeration contains a null element") : null;
    }

    @Nonnull
    public static <T> Traverser<T> traverseStream(@Nonnull Stream<T> stream) {
        return Traversers.traverseSpliterator(stream.spliterator()).onFirstNull(stream::close);
    }

    @Nonnull
    public static <T> Traverser<T> traverseIterable(@Nonnull Iterable<? extends T> iterable) {
        return Traversers.traverseIterator(iterable.iterator());
    }

    @Nonnull
    public static <T> Traverser<T> traverseArray(@Nonnull T[] array) {
        return new ArrayTraverser<T>(array);
    }

    @SafeVarargs
    public static <T> Traverser<T> traverseItems(T ... items) {
        return Traversers.traverseArray(items);
    }

    @Nonnull
    public static <T> Traverser<T> lazy(@Nonnull Supplier<Traverser<T>> supplierOfTraverser) {
        return new LazyTraverser<T>(supplierOfTraverser);
    }

    private static class SingletonTraverser<T>
    implements Traverser<T> {
        private Object item;

        SingletonTraverser(@Nonnull T item) {
            this.item = item;
        }

        @Override
        public T next() {
            try {
                Object object = this.item;
                return (T)object;
            }
            finally {
                this.item = null;
            }
        }

        @Override
        @Nonnull
        public <R> Traverser<R> map(@Nonnull Function<? super T, ? extends R> mapFn) {
            if (this.item != null) {
                this.item = mapFn.apply(this.item);
            }
            return this;
        }
    }

    private static class SpliteratorTraverser<T>
    implements Traverser<T>,
    Consumer<T> {
        private final Spliterator<T> spliterator;
        private T nextItem;

        SpliteratorTraverser(Spliterator<T> spliterator) {
            this.spliterator = spliterator;
        }

        @Override
        public T next() {
            try {
                boolean advanced = this.spliterator.tryAdvance(this);
                if (advanced) {
                    Objects.requireNonNull(this.nextItem);
                }
                T t = this.nextItem;
                return t;
            }
            finally {
                this.nextItem = null;
            }
        }

        @Override
        public void accept(T t) {
            this.nextItem = t;
        }
    }

    private static class ArrayTraverser<T>
    implements Traverser<T> {
        private int i;
        private final T[] array;

        ArrayTraverser(@Nonnull T[] array) {
            this.array = array;
        }

        @Override
        public T next() {
            return this.i >= 0 && this.i < this.array.length ? (T)Objects.requireNonNull(this.array[this.i++], "Array contains a null element") : null;
        }
    }

    private static final class LazyTraverser<T>
    implements Traverser<T> {
        private Supplier<Traverser<T>> supplierOfTraverser;
        private Traverser<T> traverser;

        LazyTraverser(@Nonnull Supplier<Traverser<T>> supplierOfTraverser) {
            this.supplierOfTraverser = supplierOfTraverser;
        }

        @Override
        public T next() {
            Traverser<T> trav = this.traverser;
            if (trav != null) {
                return trav.next();
            }
            try {
                this.traverser = this.supplierOfTraverser.get();
                T t = this.traverser.next();
                return t;
            }
            finally {
                this.supplierOfTraverser = null;
            }
        }
    }
}

