/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.test;

import java.util.Objects;

final class JetAssert {
    private JetAssert() {
    }

    static void assertTrue(String message, boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)message);
        }
    }

    static void assertFalse(String message, boolean condition) {
        JetAssert.assertTrue(message, !condition);
    }

    static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        JetAssert.throwNotEqual(message, expected, actual);
    }

    static void assertEquals(String message, Object expected, Object actual) {
        if (Objects.equals(expected, actual)) {
            return;
        }
        JetAssert.throwNotEqual(message, expected, actual);
    }

    private static void throwNotEqual(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        if (message != null && !message.equals("")) {
            message = message + " ";
        }
        message = (expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual)) ? message + "expected: " + JetAssert.formatClassAndValue(expected, expectedString) + " but was: " + JetAssert.formatClassAndValue(actual, actualString) : message + "expected:<" + expectedString + "> but was:<" + actualString + ">";
        throw new AssertionError((Object)message);
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }
}

