/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.config.XmlJetClientConfigLocator;
import com.hazelcast.jet.impl.config.XmlJetConfigBuilder;
import com.hazelcast.jet.impl.config.XmlJetConfigLocator;
import com.hazelcast.jet.impl.config.YamlJetClientConfigLocator;
import com.hazelcast.jet.impl.config.YamlJetConfigBuilder;
import com.hazelcast.jet.impl.config.YamlJetConfigLocator;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConfigProvider {
    private ConfigProvider() {
    }

    @Nonnull
    public static JetConfig locateAndGetJetConfig(@Nullable Properties properties) {
        JetConfig config;
        XmlJetConfigLocator xmlConfigLocator = new XmlJetConfigLocator();
        YamlJetConfigLocator yamlConfigLocator = new YamlJetConfigLocator();
        if (yamlConfigLocator.locateFromSystemProperty()) {
            config = new YamlJetConfigBuilder(yamlConfigLocator).setProperties(properties).build();
        } else if (xmlConfigLocator.locateFromSystemProperty()) {
            config = new XmlJetConfigBuilder(xmlConfigLocator).setProperties(properties).build();
        } else if (xmlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new XmlJetConfigBuilder(xmlConfigLocator).setProperties(properties).build();
        } else if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new YamlJetConfigBuilder(yamlConfigLocator).setProperties(properties).build();
        } else {
            xmlConfigLocator.locateDefault();
            config = new XmlJetConfigBuilder(xmlConfigLocator).setProperties(properties).build();
        }
        return config;
    }

    @Nonnull
    public static JetConfig locateAndGetJetConfig() {
        return ConfigProvider.locateAndGetJetConfig(null);
    }

    @Nonnull
    public static ClientConfig locateAndGetClientConfig() {
        ClientConfig config;
        XmlJetClientConfigLocator xmlConfigLocator = new XmlJetClientConfigLocator();
        YamlJetClientConfigLocator yamlConfigLocator = new YamlJetClientConfigLocator();
        if (yamlConfigLocator.locateFromSystemProperty()) {
            config = new YamlClientConfigBuilder(yamlConfigLocator.getIn()).build();
        } else if (xmlConfigLocator.locateFromSystemProperty()) {
            config = new XmlClientConfigBuilder(xmlConfigLocator.getIn()).build();
        } else if (xmlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new XmlClientConfigBuilder(xmlConfigLocator.getIn()).build();
        } else if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new YamlClientConfigBuilder(yamlConfigLocator.getIn()).build();
        } else {
            xmlConfigLocator.locateDefault();
            config = new XmlClientConfigBuilder(xmlConfigLocator.getIn()).build();
        }
        return config;
    }
}

