/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.impl.operation.SnapshotOperation;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SnapshotContext {
    private final ILogger logger;
    private final String jobNameAndExecutionId;
    private final ProcessingGuarantee guarantee;
    private volatile boolean isTerminal;
    private int numTasklets = Integer.MIN_VALUE;
    private int numHigherPriorityTasklets = Integer.MIN_VALUE;
    private final AtomicInteger numRemainingTasklets = new AtomicInteger();
    private final AtomicReference<Throwable> snapshotError = new AtomicReference();
    private volatile long activeSnapshotId;
    private long currentSnapshotId;
    private volatile String currentMapName;
    private volatile CompletableFuture<SnapshotOperation.SnapshotOperationResult> future;
    private final AtomicLong totalBytes = new AtomicLong();
    private final AtomicLong totalKeys = new AtomicLong();
    private final AtomicLong totalChunks = new AtomicLong();
    private boolean isCancelled;

    public SnapshotContext(ILogger logger, String jobNameAndExecutionId, long activeSnapshotId, ProcessingGuarantee guarantee) {
        this.jobNameAndExecutionId = jobNameAndExecutionId;
        this.activeSnapshotId = this.currentSnapshotId = activeSnapshotId;
        this.guarantee = guarantee;
        this.logger = logger;
    }

    long activeSnapshotId() {
        return this.activeSnapshotId;
    }

    public long currentSnapshotId() {
        return this.currentSnapshotId;
    }

    public String currentMapName() {
        return this.currentMapName;
    }

    boolean isTerminalSnapshot() {
        return this.isTerminal;
    }

    ProcessingGuarantee processingGuarantee() {
        return this.guarantee;
    }

    synchronized void initTaskletCount(int totalTaskletCount, int highPriorityTaskletCount) {
        assert (this.numTasklets == Integer.MIN_VALUE) : "Tasklet count already set once.";
        assert (totalTaskletCount >= highPriorityTaskletCount) : "totalTaskletCount=" + totalTaskletCount + ", highPriorityTaskletCount=" + highPriorityTaskletCount;
        assert (totalTaskletCount > 0) : "totalTaskletCount=" + totalTaskletCount;
        assert (highPriorityTaskletCount >= 0) : "highPriorityTaskletCount=" + highPriorityTaskletCount;
        this.numTasklets = totalTaskletCount;
        this.numHigherPriorityTasklets = highPriorityTaskletCount;
    }

    synchronized CompletableFuture<SnapshotOperation.SnapshotOperationResult> startNewSnapshot(long snapshotId, String mapName, boolean isTerminal) {
        if (snapshotId == this.currentSnapshotId) {
            throw new RuntimeException("new snapshotId equal to previous, operation possibly retried. Previous=" + this.currentSnapshotId + ", new=" + snapshotId);
        }
        assert (snapshotId == this.currentSnapshotId + 1L) : "New snapshotId for " + this.jobNameAndExecutionId + " not incremented by 1. Previous=" + this.currentSnapshotId + ", new=" + snapshotId;
        assert (this.currentSnapshotId == this.activeSnapshotId) : "last snapshot was postponed but not started";
        assert (this.numTasklets >= 0) : "numTasklets=" + this.numTasklets;
        if (this.isCancelled) {
            throw new CancellationException("execution cancelled");
        }
        this.isTerminal = isTerminal;
        boolean success = this.numRemainingTasklets.compareAndSet(0, this.numTasklets);
        assert (success) : "numRemainingTasklets wasn't 0, but " + this.numRemainingTasklets.get();
        this.currentSnapshotId = snapshotId;
        this.currentMapName = mapName;
        if (this.numHigherPriorityTasklets == 0) {
            this.activeSnapshotId = this.currentSnapshotId;
        } else {
            this.logger.info("Snapshot " + snapshotId + " for " + this.jobNameAndExecutionId + " is postponed until all higher priority vertices are completed (number of such vertices = " + this.numHigherPriorityTasklets + ')');
        }
        if (this.numTasklets == 0) {
            return CompletableFuture.completedFuture(new SnapshotOperation.SnapshotOperationResult(0L, 0L, 0L, null));
        }
        this.future = new CompletableFuture();
        return this.future;
    }

    synchronized void taskletDone(long lastCompletedSnapshotId, boolean isHigherPrioritySource) {
        assert (this.numTasklets > 0) : "numTasklets=" + this.numTasklets;
        assert (lastCompletedSnapshotId <= this.activeSnapshotId) : "activeSnapshotId=" + this.activeSnapshotId + ", tasklet.lastCompletedSnapshotId=" + lastCompletedSnapshotId;
        --this.numTasklets;
        if (isHigherPrioritySource) {
            assert (this.numHigherPriorityTasklets > 0) : "numHigherPriorityTasklets=" + this.numHigherPriorityTasklets;
            --this.numHigherPriorityTasklets;
            if (this.numHigherPriorityTasklets == 0 && this.activeSnapshotId < this.currentSnapshotId) {
                this.activeSnapshotId = this.currentSnapshotId;
                this.logger.info("Postponed snapshot " + this.activeSnapshotId + " for " + this.jobNameAndExecutionId + " started");
            }
        }
        assert (this.numHigherPriorityTasklets <= this.numTasklets) : "numHigherPriorityTasklets > numTasklets";
        assert (lastCompletedSnapshotId <= this.currentSnapshotId) : "tasklet completed a snapshot that didn't start yet";
        if (lastCompletedSnapshotId < this.currentSnapshotId) {
            this.snapshotDoneForTasklet(0L, 0L, 0L);
        }
    }

    void snapshotDoneForTasklet(long numBytes, long numKeys, long numChunks) {
        this.totalBytes.addAndGet(numBytes);
        this.totalKeys.addAndGet(numKeys);
        this.totalChunks.addAndGet(numChunks);
        int newRemainingTasklets = this.numRemainingTasklets.decrementAndGet();
        assert (newRemainingTasklets >= 0) : "newRemainingTasklets=" + newRemainingTasklets;
        if (newRemainingTasklets == 0) {
            this.handleSnapshotDone();
        }
    }

    synchronized void cancel() {
        if (this.future != null) {
            this.reportError(new CancellationException("execution cancelled"));
            this.handleSnapshotDone();
        }
        this.isCancelled = true;
    }

    private synchronized void handleSnapshotDone() {
        if (this.isCancelled) {
            assert (this.future == null) : "future=" + this.future;
            return;
        }
        this.future.complete(new SnapshotOperation.SnapshotOperationResult(this.totalBytes.get(), this.totalKeys.get(), this.totalChunks.get(), this.snapshotError.get()));
        this.future = null;
        this.snapshotError.set(null);
        this.totalBytes.set(0L);
        this.totalKeys.set(0L);
        this.totalChunks.set(0L);
        this.currentMapName = null;
    }

    void reportError(Throwable ex) {
        this.snapshotError.compareAndSet(null, ex);
    }

    AtomicInteger getNumRemainingTasklets() {
        return this.numRemainingTasklets;
    }
}

