/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.pipeline.AbstractStage;
import com.hazelcast.jet.impl.pipeline.BatchStageImpl;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.pipeline.SinkStageImpl;
import com.hazelcast.jet.impl.pipeline.StreamSourceStageImpl;
import com.hazelcast.jet.impl.pipeline.transform.BatchSourceTransform;
import com.hazelcast.jet.impl.pipeline.transform.SinkTransform;
import com.hazelcast.jet.impl.pipeline.transform.StreamSourceTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkStage;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.pipeline.StreamSourceStage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class PipelineImpl
implements Pipeline {
    private final Map<Transform, List<Transform>> adjacencyMap = new LinkedHashMap<Transform, List<Transform>>();

    @Override
    @Nonnull
    public <T> BatchStage<T> drawFrom(@Nonnull BatchSource<? extends T> source) {
        BatchSourceTransform xform = (BatchSourceTransform)source;
        xform.onAssignToStage();
        return new BatchStageImpl(xform, this);
    }

    @Override
    @Nonnull
    public <T> StreamSourceStage<T> drawFrom(@Nonnull StreamSource<? extends T> source) {
        StreamSourceTransform xform = (StreamSourceTransform)source;
        xform.onAssignToStage();
        return new StreamSourceStageImpl(xform, this);
    }

    @Override
    @Nonnull
    public <T> SinkStage drainTo(@Nonnull Sink<? super T> sink, @Nonnull GeneralStage<? extends T> stage0, @Nonnull GeneralStage<? extends T> stage1, GeneralStage<? extends T> ... moreStages) {
        GeneralStage[] stages = new GeneralStage[2 + moreStages.length];
        stages[0] = stage0;
        stages[1] = stage1;
        System.arraycopy(moreStages, 0, stages, 2, moreStages.length);
        List<Transform> upstream = Arrays.stream(stages).map(s -> (AbstractStage)((Object)s)).map(s -> s.transform).collect(Collectors.toList());
        int[] ordinalsToAdapt = IntStream.range(0, stages.length).filter(i -> ((ComputeStageImplBase)((Object)stages[i])).fnAdapter == ComputeStageImplBase.ADAPT_TO_JET_EVENT).toArray();
        SinkImpl sinkImpl = (SinkImpl)sink;
        SinkTransform sinkTransform = new SinkTransform(sinkImpl, upstream, ordinalsToAdapt);
        SinkStageImpl sinkStage = new SinkStageImpl(sinkTransform, this);
        sinkImpl.onAssignToStage();
        this.connect(upstream, sinkTransform);
        return sinkStage;
    }

    @Override
    @Nonnull
    public DAG toDag() {
        return new Planner(this).createDag();
    }

    public void connect(Transform upstream, Transform downstream) {
        this.adjacencyMap.get(upstream).add(downstream);
    }

    public void connect(List<Transform> upstream, Transform downstream) {
        upstream.forEach(u -> this.connect((Transform)u, downstream));
    }

    public String toString() {
        return "Pipeline " + this.adjacencyMap;
    }

    @Override
    @Nonnull
    public String toDotString() {
        this.makeNamesUnique();
        Map<Transform, List<Transform>> adjMap = this.adjacencyMap();
        HashMap<Transform, String> transformNames = new HashMap<Transform, String>();
        StringBuilder builder = new StringBuilder(256);
        builder.append("digraph Pipeline {\n");
        for (Map.Entry<Transform, List<Transform>> entry : adjMap.entrySet()) {
            Transform src = entry.getKey();
            String srcName = transformNames.computeIfAbsent(src, Transform::name);
            for (Transform dest : entry.getValue()) {
                String destName = transformNames.computeIfAbsent(dest, Transform::name);
                builder.append("\t").append("\"").append(Util.escapeGraphviz(srcName)).append("\"").append(" -> ").append("\"").append(Util.escapeGraphviz(destName)).append("\"").append(";\n");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    Map<Transform, List<Transform>> adjacencyMap() {
        LinkedHashMap<Transform, List<Transform>> safeCopy = new LinkedHashMap<Transform, List<Transform>>();
        this.adjacencyMap.forEach((k, v) -> {
            List cfr_ignored_0 = safeCopy.put((Transform)k, new ArrayList(v));
        });
        return safeCopy;
    }

    void register(Transform stage, List<Transform> downstream) {
        List<Transform> prev = this.adjacencyMap.put(stage, downstream);
        assert (prev == null) : "Double registration of a Stage with this Pipeline: " + stage;
    }

    void makeNamesUnique() {
        HashSet<String> usedNames = new HashSet<String>();
        for (Transform transform : this.adjacencyMap.keySet()) {
            while (!usedNames.add(transform.name())) {
                transform.setName(Util.addOrIncrementIndexInName(transform.name()));
            }
        }
    }
}

