/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class JetGetClusterMetadataCodec {
    public static final JetMessageType REQUEST_TYPE = JetMessageType.JET_GETCLUSTERMETADATA;
    public static final int RESPONSE_TYPE = 131;

    public static ClientMessage encodeRequest() {
        int requiredDataSize = RequestParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Jet.getClusterMetadata");
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        return parameters;
    }

    public static ClientMessage encodeResponse(String name, String version, long clusterTime, int state) {
        int requiredDataSize = ResponseParameters.calculateDataSize(name, version, clusterTime, state);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(131);
        clientMessage.set(name);
        clientMessage.set(version);
        clientMessage.set(clusterTime);
        clientMessage.set(state);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        String version = null;
        parameters.version = version = clientMessage.getStringUtf8();
        long clusterTime = 0L;
        parameters.clusterTime = clusterTime = clientMessage.getLong();
        int state = 0;
        parameters.state = state = clientMessage.getInt();
        return parameters;
    }

    public static class ResponseParameters {
        public String name;
        public String version;
        public long clusterTime;
        public int state;

        public static int calculateDataSize(String name, String version, long clusterTime, int state) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            dataSize += ParameterUtil.calculateDataSize(version);
            dataSize += 8;
            return dataSize += 4;
        }
    }

    public static class RequestParameters {
        public static final JetMessageType TYPE = REQUEST_TYPE;

        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }
}

