/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetMessageType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class JetTerminateJobCodec {
    public static final JetMessageType REQUEST_TYPE = JetMessageType.JET_TERMINATEJOB;
    public static final int RESPONSE_TYPE = 100;

    public static ClientMessage encodeRequest(long jobId, int terminateMode) {
        int requiredDataSize = RequestParameters.calculateDataSize(jobId, terminateMode);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Jet.terminateJob");
        clientMessage.set(jobId);
        clientMessage.set(terminateMode);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        long jobId = 0L;
        parameters.jobId = jobId = clientMessage.getLong();
        int terminateMode = 0;
        parameters.terminateMode = terminateMode = clientMessage.getInt();
        return parameters;
    }

    public static ClientMessage encodeResponse() {
        int requiredDataSize = ResponseParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(100);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        return parameters;
    }

    public static class ResponseParameters {
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final JetMessageType TYPE = REQUEST_TYPE;
        public long jobId;
        public int terminateMode;

        public static int calculateDataSize(long jobId, int terminateMode) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 8;
            return dataSize += 4;
        }
    }
}

