/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.Member;
import com.hazelcast.internal.metrics.MetricsUtil;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.metrics.JobMetrics;
import com.hazelcast.jet.core.metrics.Measurement;
import com.hazelcast.jet.impl.metrics.Metric;
import com.hazelcast.jet.impl.metrics.MetricsCompressor;
import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public final class JobMetricsUtil {
    private static final Pattern METRIC_KEY_EXEC_ID_PATTERN = Pattern.compile("\\[module=jet,job=[^,]+,exec=([^,]+),.*");

    private JobMetricsUtil() {
    }

    public static Long getExecutionIdFromMetricDescriptor(@Nonnull String descriptor) {
        Objects.requireNonNull(descriptor, "descriptor");
        Matcher m = METRIC_KEY_EXEC_ID_PATTERN.matcher(descriptor);
        if (!m.matches()) {
            return null;
        }
        return Util.idFromString(m.group(1));
    }

    public static String addPrefixToDescriptor(@Nonnull String descriptor, @Nonnull String prefix) {
        assert (!prefix.isEmpty()) : "Prefix is empty";
        assert (prefix.endsWith(",")) : "Prefix should end in a comma";
        assert (descriptor.length() >= 3) : "Descriptor too short";
        assert (descriptor.startsWith("[")) : "Descriptor of non-standard format";
        assert (descriptor.endsWith("]")) : "Descriptor of non-standard format";
        return "[" + prefix + descriptor.substring(1);
    }

    public static String getMemberPrefix(@Nonnull Member member) {
        Objects.requireNonNull(member, "member");
        String uuid = member.getUuid();
        String address = member.getAddress().toString();
        return "member=" + MetricsUtil.escapeMetricNamePart(uuid) + "," + "address" + "=" + MetricsUtil.escapeMetricNamePart(address) + ",";
    }

    static JobMetrics toJobMetrics(List<RawJobMetrics> rawJobMetrics) {
        return JobMetrics.of(rawJobMetrics.stream().filter(r -> r.getBlob() != null).flatMap(r -> JobMetricsUtil.metricStream(r).map(metric -> JobMetricsUtil.toMeasurement(r.getTimestamp(), metric))));
    }

    private static Stream<Metric> metricStream(RawJobMetrics r) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(MetricsCompressor.decompressingIterator(r.getBlob()), 256), false);
    }

    private static Measurement toMeasurement(long timestamp, Metric metric) {
        String descriptor = metric.key();
        Map<String, String> tags = MetricsUtil.parseMetricName(descriptor).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Measurement.of(metric.value(), timestamp, tags);
    }
}

