/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics.management;

import com.hazelcast.jet.impl.metrics.MetricsCompressor;
import com.hazelcast.jet.impl.metrics.MetricsPublisher;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nonnull;

public class ManagementCenterPublisher
implements MetricsPublisher {
    private final ILogger logger;
    private final ObjLongConsumer<byte[]> consumer;
    private final MetricsCompressor compressor;

    public ManagementCenterPublisher(@Nonnull LoggingService loggingService, @Nonnull ObjLongConsumer<byte[]> writeFn) {
        this.consumer = writeFn;
        this.logger = loggingService.getLogger(this.getClass());
        this.compressor = new MetricsCompressor();
    }

    @Override
    public String name() {
        return "Management Center Publisher";
    }

    @Override
    public void publishLong(String name, long value) {
        this.compressor.addLong(name, value);
    }

    @Override
    public void publishDouble(String name, double value) {
        this.compressor.addDouble(name, value);
    }

    @Override
    public void whenComplete() {
        int count = this.compressor.count();
        byte[] blob = this.compressor.getBlobAndReset();
        this.consumer.accept(blob, System.currentTimeMillis());
        LoggingUtil.logFinest(this.logger, "Collected %,d metrics, %,d bytes", count, blob.length);
    }

    public int getCount() {
        return this.compressor.count();
    }
}

