/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.BiPredicateEx;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.ContextFactory;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class ProcessorTransform
extends AbstractTransform {
    public static final int NON_COOPERATIVE_DEFAULT_LOCAL_PARALLELISM = 2;
    final ProcessorMetaSupplier processorSupplier;

    ProcessorTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull ProcessorMetaSupplier processorSupplier) {
        super(name, upstream);
        this.processorSupplier = processorSupplier;
    }

    public static ProcessorTransform customProcessorTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull ProcessorMetaSupplier createProcessorFn) {
        return new ProcessorTransform(name, upstream, createProcessorFn);
    }

    public static <C, T, R> ProcessorTransform mapUsingContextTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, ? extends R> mapFn) {
        return new ProcessorTransform("mapUsingContext", upstream, ProcessorMetaSupplier.of(ProcessorTransform.getPreferredLP(contextFactory), Processors.mapUsingContextP(contextFactory, mapFn)));
    }

    public static <C, T> ProcessorTransform filterUsingContextTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull BiPredicateEx<? super C, ? super T> filterFn) {
        return new ProcessorTransform("filterUsingContext", upstream, ProcessorMetaSupplier.of(ProcessorTransform.getPreferredLP(contextFactory), Processors.filterUsingContextP(contextFactory, filterFn)));
    }

    public static <C, T, R> ProcessorTransform flatMapUsingContextTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return new ProcessorTransform("flatMapUsingContext", upstream, ProcessorMetaSupplier.of(ProcessorTransform.getPreferredLP(contextFactory), Processors.flatMapUsingContextP(contextFactory, flatMapFn)));
    }

    public static <C, T, R> ProcessorTransform flatMapUsingContextAsyncTransform(@Nonnull Transform upstream, @Nonnull String operationName, @Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<? super C, ? super T, CompletableFuture<Traverser<R>>> flatMapAsyncFn) {
        return new ProcessorTransform(operationName + "UsingContextAsync", upstream, ProcessorMetaSupplier.of(ProcessorTransform.getPreferredLP(contextFactory), Processors.flatMapUsingContextAsyncP(contextFactory, Object::hashCode, flatMapAsyncFn)));
    }

    static <C> int getPreferredLP(@Nonnull ContextFactory<C> contextFactory) {
        return contextFactory.isCooperative() ? -1 : 2;
    }

    @Override
    public void addToDag(Planner p) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.localParallelism(), this.processorSupplier);
        p.addEdges(this, pv.v);
    }
}

