/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConfigXmlGenerator;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapPutAllCodec;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.map.AbstractEntryProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.map.impl.proxy.NearCachedMapProxyImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.function.Function;
import com.hazelcast.util.function.Predicate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ImdgUtil {
    private static final float PUT_ALL_INITIAL_SIZE_MAGIC = 20.0f;

    private ImdgUtil() {
    }

    public static boolean existsDistributedObject(NodeEngine nodeEngine, String serviceName, String objectName) {
        return nodeEngine.getProxyService().getDistributedObjectNames(serviceName).contains(objectName);
    }

    public static <K, V> EntryProcessor<K, V> entryProcessor(final BiFunctionEx<? super K, ? super V, ? extends V> remappingFunction) {
        return new AbstractEntryProcessor<K, V>(){

            @Override
            public Object process(Map.Entry<K, V> entry) {
                Object newValue = remappingFunction.apply(entry.getKey(), entry.getValue());
                entry.setValue(newValue);
                return newValue;
            }
        };
    }

    public static boolean isMemberInstance(HazelcastInstance instance) {
        return instance.getLocalEndpoint() instanceof Member;
    }

    public static String asXmlString(ClientConfig clientConfig) {
        return clientConfig == null ? null : ClientConfigXmlGenerator.generate(clientConfig);
    }

    public static ClientConfig asClientConfig(String xml) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        return new XmlClientConfigBuilder(inputStream).build();
    }

    public static <T> PredicateEx<T> wrapImdgPredicate(Predicate<T> predicate) {
        return new ImdgPredicateWrapper<T>(predicate);
    }

    public static <T> Predicate<T> maybeUnwrapImdgPredicate(PredicateEx<T> predicate) {
        if (predicate instanceof ImdgPredicateWrapper) {
            return ((ImdgPredicateWrapper)predicate).wrapped;
        }
        return predicate;
    }

    public static FunctionEx wrapImdgFunction(Function function) {
        return new ImdgFunctionWrapper(function);
    }

    public static <T, R> Function<T, R> maybeUnwrapImdgFunction(FunctionEx<T, R> function) {
        if (function instanceof ImdgFunctionWrapper) {
            return ((ImdgFunctionWrapper)function).wrapped;
        }
        return function;
    }

    public static <K, V> CompletionStage<Void> mapPutAllAsync(@Nonnull IMap<K, V> targetIMap, Map<? extends K, ? extends V> items) {
        if (items.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        if (items.size() == 1) {
            Map.Entry<K, V> onlyEntry = items.entrySet().iterator().next();
            return Util.toCompletableFuture(targetIMap.setAsync((Object)onlyEntry.getKey(), (Object)onlyEntry.getValue()));
        }
        if (targetIMap instanceof MapProxyImpl) {
            return ImdgUtil.mapPutAllAsync((MapProxyImpl)targetIMap, items);
        }
        if (targetIMap instanceof ClientMapProxy) {
            return ImdgUtil.mapPutAllAsync((ClientMapProxy)targetIMap, items);
        }
        throw new RuntimeException("Unexpected map class: " + targetIMap.getClass().getName());
    }

    private static <K, V> CompletionStage<Void> mapPutAllAsync(@Nonnull MapProxyImpl<K, V> targetMap, @Nonnull Map<? extends K, ? extends V> items) {
        NodeEngine nodeEngine = targetMap.getNodeEngine();
        SerializationService serializationService = nodeEngine.getSerializationService();
        IPartitionService partitionService = nodeEngine.getPartitionService();
        Map<Address, List<Integer>> memberPartitionsMap = partitionService.getMemberPartitionsMap();
        MapEntries[] entries = new MapEntries[partitionService.getPartitionCount()];
        int initialSize = (int)Math.ceil((double)(20.0f * (float)items.size() / (float)partitionService.getPartitionCount()) / Math.log10(items.size()));
        for (Map.Entry<K, V> entry : items.entrySet()) {
            Preconditions.checkNotNull(entry.getKey(), "Null key is not allowed");
            Preconditions.checkNotNull(entry.getValue(), "Null value is not allowed");
            Object keyData = serializationService.toData(entry.getKey(), targetMap.getPartitionStrategy());
            int partitionId = partitionService.getPartitionId((Data)keyData);
            MapEntries partitionEntries = entries[partitionId];
            if (partitionEntries == null) {
                entries[partitionId] = partitionEntries = new MapEntries(initialSize);
            }
            partitionEntries.add((Data)keyData, (Data)serializationService.toData(entry.getValue()));
        }
        int[] subPartitions = new int[memberPartitionsMap.values().stream().mapToInt(List::size).max().orElse(0)];
        MapEntries[] subEntries = new MapEntries[subPartitions.length];
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        ExecutionCallback<Object> callback = ImdgUtil.createPutAllCallback(memberPartitionsMap.size(), targetMap instanceof NearCachedMapProxyImpl ? ((NearCachedMapProxyImpl)targetMap).getNearCache() : null, items.keySet(), Stream.of(entries).filter(Objects::nonNull).flatMap(e -> e.entries().stream()).map(Map.Entry::getKey), resultFuture);
        for (Map.Entry<Address, List<Integer>> entry : memberPartitionsMap.entrySet()) {
            List<Integer> memberPartitions = entry.getValue();
            int count = 0;
            for (int partitionId : memberPartitions) {
                if (entries[partitionId] == null) continue;
                subPartitions[count] = partitionId;
                subEntries[count] = entries[partitionId];
                ++count;
            }
            if (count == 0) {
                callback.onResponse(null);
                continue;
            }
            int[] subPartitionsTrimmed = Arrays.copyOf(subPartitions, count);
            MapEntries[] subEntriesTrimmed = Arrays.copyOf(subEntries, count);
            if (count <= 0) continue;
            OperationFactory factory = targetMap.getOperationProvider().createPutAllOperationFactory(targetMap.getName(), subPartitionsTrimmed, subEntriesTrimmed);
            targetMap.getOperationService().invokeOnPartitionsAsync("hz:impl:mapService", factory, ImdgUtil.asIntegerList(subPartitionsTrimmed)).andThen(callback);
        }
        return resultFuture;
    }

    private static <K, V> CompletionStage<Void> mapPutAllAsync(ClientMapProxy<K, V> targetMap, Map<? extends K, ? extends V> items) {
        if (items.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Preconditions.checkNotNull(targetMap, "Null argument map is not allowed");
        ClientPartitionService partitionService = targetMap.getContext().getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        HashMap<Integer, List> entryMap = new HashMap<Integer, List>(partitionCount);
        InternalSerializationService serializationService = targetMap.getContext().getSerializationService();
        for (Map.Entry<K, V> entry : items.entrySet()) {
            Preconditions.checkNotNull(entry.getKey(), "Null key is not allowed");
            Preconditions.checkNotNull(entry.getValue(), "Null value is not allowed");
            Object keyData = serializationService.toData(entry.getKey());
            int partitionId = partitionService.getPartitionId((Data)keyData);
            entryMap.computeIfAbsent(partitionId, k -> new ArrayList()).add(new AbstractMap.SimpleEntry(keyData, serializationService.toData(entry.getValue())));
        }
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)targetMap.getContext().getHazelcastInstance();
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        ExecutionCallback<Object> callback = ImdgUtil.createPutAllCallback(entryMap.size(), targetMap instanceof NearCachedClientMapProxy ? ((NearCachedClientMapProxy)targetMap).getNearCache() : null, items.keySet(), entryMap.values().stream().flatMap(Collection::stream).map(Map.Entry::getKey), resultFuture);
        for (Map.Entry partitionEntries : entryMap.entrySet()) {
            Integer partitionId = (Integer)partitionEntries.getKey();
            if (((List)partitionEntries.getValue()).size() == 1) {
                Map.Entry onlyEntry = (Map.Entry)((List)partitionEntries.getValue()).get(0);
                targetMap.setAsync(onlyEntry.getKey(), onlyEntry.getValue()).andThen(callback);
                continue;
            }
            ClientMessage request = MapPutAllCodec.encodeRequest(targetMap.getName(), (Collection)partitionEntries.getValue());
            new ClientInvocation(client, request, targetMap.getName(), partitionId).invoke().andThen((ExecutionCallback<ClientMessage>)callback);
        }
        return resultFuture;
    }

    private static ExecutionCallback<Object> createPutAllCallback(int participantCount, final @Nullable NearCache<Object, Object> nearCache, final @Nonnull Set<?> nonSerializedKeys, final @Nonnull Stream<Data> serializedKeys, final CompletableFuture<Void> resultFuture) {
        final AtomicInteger completionCounter = new AtomicInteger(participantCount);
        return new ExecutionCallback<Object>(){

            @Override
            public void onResponse(Object response) {
                if (completionCounter.decrementAndGet() > 0) {
                    return;
                }
                if (nearCache != null) {
                    if (nearCache.isSerializeKeys()) {
                        serializedKeys.forEach(nearCache::invalidate);
                    } else {
                        for (Object key : nonSerializedKeys) {
                            nearCache.invalidate(key);
                        }
                    }
                }
                resultFuture.complete(null);
            }

            @Override
            public void onFailure(Throwable t) {
                resultFuture.completeExceptionally(t);
            }
        };
    }

    private static List<Integer> asIntegerList(final int[] array) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return array[index];
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    @Nonnull
    public static List<Address> getRemoteMembers(@Nonnull NodeEngine engine) {
        Member localMember = engine.getLocalMember();
        return engine.getClusterService().getMembers().stream().filter(m -> !m.equals(localMember)).map(Member::getAddress).collect(Collectors.toList());
    }

    public static Connection getMemberConnection(@Nonnull NodeEngine engine, @Nonnull Address memberAddr) {
        return ((NodeEngineImpl)engine).getNode().getEndpointManager().getConnection(memberAddr);
    }

    public static <T> ExecutionCallback<T> callbackOf(final @Nonnull Consumer<T> onResponse, final @Nonnull Consumer<Throwable> onError) {
        return new ExecutionCallback<T>(){

            @Override
            public void onResponse(T o) {
                onResponse.accept(o);
            }

            @Override
            public void onFailure(Throwable throwable) {
                onError.accept(throwable);
            }
        };
    }

    public static <T> ExecutionCallback<T> callbackOf(final BiConsumer<T, Throwable> callback) {
        return new ExecutionCallback<T>(){

            @Override
            public void onResponse(T o) {
                callback.accept(o, null);
            }

            @Override
            public void onFailure(Throwable throwable) {
                callback.accept(null, throwable);
            }
        };
    }

    @Nonnull
    public static BufferObjectDataOutput createObjectDataOutput(@Nonnull NodeEngine engine) {
        return ((InternalSerializationService)engine.getSerializationService()).createObjectDataOutput(32768);
    }

    @Nonnull
    public static BufferObjectDataInput createObjectDataInput(@Nonnull NodeEngine engine, @Nonnull byte[] buf) {
        return ((InternalSerializationService)engine.getSerializationService()).createObjectDataInput(buf);
    }

    public static void writeList(@Nonnull ObjectDataOutput output, @Nonnull List list) throws IOException {
        output.writeInt(list.size());
        for (Object o : list) {
            output.writeObject(o);
        }
    }

    @Nonnull
    public static <E> List<E> readList(@Nonnull ObjectDataInput output) throws IOException {
        int length = output.readInt();
        ArrayList list = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            list.add(output.readObject());
        }
        return list;
    }

    private static final class ImdgFunctionWrapper<T, R>
    implements FunctionEx<T, R> {
        private final Function<T, R> wrapped;

        ImdgFunctionWrapper(Function<T, R> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public R applyEx(T t) {
            return this.wrapped.apply(t);
        }
    }

    private static final class ImdgPredicateWrapper<T>
    implements PredicateEx<T> {
        private final Predicate<T> wrapped;

        ImdgPredicateWrapper(Predicate<T> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean testEx(T t) {
            return this.wrapped.test(t);
        }
    }
}

