/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

public final class FileSinkBuilder<T> {
    private final String directoryName;
    private FunctionEx<? super T, String> toStringFn = Object::toString;
    private Charset charset = StandardCharsets.UTF_8;
    private boolean append;

    FileSinkBuilder(@Nonnull String directoryName) {
        this.directoryName = directoryName;
    }

    public FileSinkBuilder<T> toStringFn(@Nonnull FunctionEx<? super T, String> toStringFn) {
        this.toStringFn = toStringFn;
        return this;
    }

    public FileSinkBuilder<T> charset(@Nonnull Charset charset) {
        this.charset = charset;
        return this;
    }

    public FileSinkBuilder<T> append(boolean append) {
        this.append = append;
        return this;
    }

    public Sink<T> build() {
        return Sinks.fromProcessor("filesSink(" + this.directoryName + ')', SinkProcessors.writeFileP(this.directoryName, this.toStringFn, this.charset, this.append));
    }
}

