/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.instance.Node;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.operation.PrepareForPassiveClusterOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

class NodeExtensionCommon {
    private static final String JET_LOGO = "\to   o   o   o---o o---o o     o---o   o   o---o o-o-o        o o---o o-o-o\n\t|   |  / \\     /  |     |     |      / \\  |       |          | |       |\n\to---o o---o   o   o-o   |     o     o---o o---o   |          | o-o     |\n\t|   | |   |  /    |     |     |     |   |     |   |      \\   | |       |\n\to   o o   o o---o o---o o---o o---o o   o o---o   o       o--o o---o   o";
    private static final String COPYRIGHT_LINE = "Copyright (c) 2008-2019, Hazelcast, Inc. All Rights Reserved.";
    private final Node node;
    private final ILogger logger;
    private final JetService jetService;

    NodeExtensionCommon(Node node, JetService jetService) {
        this.node = node;
        this.logger = node.getLogger(this.getClass().getName());
        this.jetService = jetService;
    }

    void afterStart() {
        this.jetService.getJobCoordinationService().startScanningForJobs();
    }

    void beforeClusterStateChange(ClusterState requestedState) {
        if (requestedState != ClusterState.PASSIVE) {
            return;
        }
        this.logger.info("Jet is preparing to enter the PASSIVE cluster state");
        NodeEngineImpl ne = this.node.nodeEngine;
        try {
            ne.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)new PrepareForPassiveClusterOperation(), ne.getMasterAddress()).invoke().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    void onClusterStateChange(ClusterState ignored) {
        this.jetService.getJobCoordinationService().clusterChangeDone();
    }

    void handlePacket(Packet packet) {
        this.jetService.handlePacket(packet);
    }

    void printNodeInfo(ILogger log, String addToProductName) {
        log.info(this.versionAndAddressMessage(addToProductName));
        log.fine(this.serializationVersionMessage());
        log.info("\n\to   o   o   o---o o---o o     o---o   o   o---o o-o-o        o o---o o-o-o\n\t|   |  / \\     /  |     |     |      / \\  |       |          | |       |\n\to---o o---o   o   o-o   |     o     o---o o---o   |          | o-o     |\n\t|   | |   |  /    |     |     |     |   |     |   |      \\   | |       |\n\to   o o   o o---o o---o o---o o---o o   o o---o   o       o--o o---o   o");
        log.info(COPYRIGHT_LINE);
    }

    private String versionAndAddressMessage(@Nonnull String addToName) {
        JetBuildInfo jetBuildInfo = this.node.getBuildInfo().getJetBuildInfo();
        String build = jetBuildInfo.getBuild();
        String revision = jetBuildInfo.getRevision();
        if (!revision.isEmpty()) {
            build = build + " - " + revision;
        }
        return "Hazelcast Jet" + addToName + ' ' + jetBuildInfo.getVersion() + " (" + build + ") starting at " + this.node.getThisAddress();
    }

    private String serializationVersionMessage() {
        return "Configured Hazelcast Serialization version: " + this.node.getBuildInfo().getSerializationVersion();
    }

    Map<String, Object> createExtensionServices() {
        HashMap<String, Object> extensionServices = new HashMap<String, Object>();
        extensionServices.put("hz:impl:jetService", this.jetService);
        return extensionServices;
    }
}

