/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.function.FunctionEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nonnull;

public final class WriteFileP {
    private WriteFileP() {
    }

    public static <T> ProcessorMetaSupplier metaSupplier(@Nonnull String directoryName, @Nonnull FunctionEx<? super T, ? extends String> toStringFn, @Nonnull String charset, boolean append) {
        return ProcessorMetaSupplier.preferLocalParallelismOne(SinkProcessors.writeBufferedP(ctx -> WriteFileP.createBufferedWriter(Paths.get(directoryName, new String[0]), ctx.globalProcessorIndex(), charset, append), (fileWriter, item) -> {
            fileWriter.write((String)toStringFn.apply(item));
            fileWriter.newLine();
        }, BufferedWriter::flush, BufferedWriter::close));
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="mkdirs() returns false if the directory already existed, which is good. We don't care even if it didn't exist and we failed to create it, because we'll fail later when trying to create the file.")
    private static BufferedWriter createBufferedWriter(Path directory, int globalIndex, String charset, boolean append) throws IOException {
        directory.toFile().mkdirs();
        Path file = directory.resolve(String.valueOf(globalIndex));
        return Files.newBufferedWriter(file, Charset.forName(charset), StandardOpenOption.CREATE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
    }
}

