/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.Comparator;
import java.util.PriorityQueue;

public final class PriorityQueueHook
implements SerializerHook<PriorityQueue> {
    @Override
    public Class<PriorityQueue> getSerializationType() {
        return PriorityQueue.class;
    }

    @Override
    public Serializer createSerializer() {
        return new StreamSerializer<PriorityQueue>(){

            @Override
            public int getTypeId() {
                return -326;
            }

            @Override
            public void destroy() {
            }

            @Override
            public void write(ObjectDataOutput out, PriorityQueue queue) throws IOException {
                out.writeInt(queue.size());
                out.writeObject(queue.comparator());
                for (Object o : queue) {
                    out.writeObject(o);
                }
            }

            @Override
            public PriorityQueue read(ObjectDataInput in) throws IOException {
                int size = in.readInt();
                PriorityQueue res = new PriorityQueue(Math.max(1, size), (Comparator)in.readObject());
                for (int i = 0; i < size; ++i) {
                    res.add(in.readObject());
                }
                return res;
            }
        };
    }

    @Override
    public boolean isOverwritable() {
        return true;
    }
}

