/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.metrics;

import com.hazelcast.jet.core.metrics.Measurement;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class MeasurementPredicates {
    private MeasurementPredicates() {
    }

    public static Predicate<Measurement> containsTag(String tag) {
        return measurement -> measurement.getTag(tag) != null;
    }

    public static Predicate<Measurement> tagValueEquals(String tag, String value) {
        return measurement -> value.equals(measurement.getTag(tag));
    }

    public static Predicate<Measurement> tagValueMatches(String tag, String valueRegexp) {
        return measurement -> {
            String value = measurement.getTag(tag);
            return value != null && Pattern.compile(valueRegexp).matcher(value).matches();
        };
    }
}

