/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.jet.IListJet;
import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.JetCacheManager;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobAlreadyExistsException;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.IListDecorator;
import com.hazelcast.jet.impl.IMapDecorator;
import com.hazelcast.jet.impl.JetCacheManagerImpl;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class AbstractJetInstance
implements JetInstance {
    private final HazelcastInstance hazelcastInstance;
    private final JetCacheManagerImpl cacheManager;
    private final Supplier<JobRepository> jobRepository;

    public AbstractJetInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
        this.cacheManager = new JetCacheManagerImpl(this);
        this.jobRepository = Util.memoizeConcurrent(() -> new JobRepository(this));
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
        long jobId = this.uploadResourcesAndAssignId(config);
        return this.newJobProxy(jobId, dag, config);
    }

    @Override
    @Nonnull
    public Job newJobIfAbsent(@Nonnull DAG dag, @Nonnull JobConfig config) {
        if (config.getName() == null) {
            return this.newJob(dag, config);
        }
        JobStatus status;
        Job job;
        while ((job = this.getJob(config.getName())) == null || (status = job.getStatus()) == JobStatus.FAILED || status == JobStatus.COMPLETED) {
            try {
                return this.newJob(dag, config);
            }
            catch (JobAlreadyExistsException e) {
                LoggingUtil.logFine(this.getLogger(), "Could not submit job with duplicate name: %s, ignoring", config.getName());
                continue;
            }
            break;
        }
        return job;
    }

    @Override
    public Job getJob(long jobId) {
        try {
            Job job = this.newJobProxy(jobId);
            job.getStatus();
            return job;
        }
        catch (Throwable t) {
            if (ExceptionUtil.peel(t) instanceof JobNotFoundException) {
                return null;
            }
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    @Nonnull
    public List<Job> getJobs(@Nonnull String name) {
        return this.getJobIdsByName(name).stream().map(this::newJobProxy).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.getHazelcastInstance().getCluster();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.hazelcastInstance.getName();
    }

    @Override
    @Nonnull
    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    @Override
    @Nonnull
    public <K, V> IMapJet<K, V> getMap(@Nonnull String name) {
        return new IMapDecorator(this.hazelcastInstance.getMap(name), this);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        return this.hazelcastInstance.getReplicatedMap(name);
    }

    @Override
    @Nonnull
    public <E> IListJet<E> getList(@Nonnull String name) {
        return new IListDecorator(this.hazelcastInstance.getList(name), this);
    }

    @Override
    @Nonnull
    public JetCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void shutdown() {
        this.hazelcastInstance.shutdown();
    }

    public abstract boolean existsDistributedObject(@Nonnull String var1, @Nonnull String var2);

    private long uploadResourcesAndAssignId(JobConfig config) {
        return this.jobRepository.get().uploadJobResources(config);
    }

    public abstract ILogger getLogger();

    public abstract Job newJobProxy(long var1);

    public abstract Job newJobProxy(long var1, DAG var3, JobConfig var4);

    public abstract List<Long> getJobIdsByName(String var1);
}

