/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.logging.ILogger;
import javax.annotation.Nonnull;

public final class Contexts {
    private Contexts() {
    }

    public static class ProcCtx
    extends ProcSupplierCtx
    implements Processor.Context {
        private final int localProcessorIndex;
        private final int globalProcessorIndex;

        public ProcCtx(JetInstance instance, long jobId, long executionId, JobConfig jobConfig, ILogger logger, String vertexName, int localProcessorIndex, int globalProcessorIndex, ProcessingGuarantee processingGuarantee, int localParallelism, int memberIndex, int memberCount) {
            super(instance, jobId, executionId, jobConfig, logger, vertexName, localParallelism, memberCount * localParallelism, memberIndex, memberCount, processingGuarantee);
            this.localProcessorIndex = localProcessorIndex;
            this.globalProcessorIndex = globalProcessorIndex;
        }

        @Override
        public int localProcessorIndex() {
            return this.localProcessorIndex;
        }

        @Override
        public int globalProcessorIndex() {
            return this.globalProcessorIndex;
        }
    }

    static class ProcSupplierCtx
    extends MetaSupplierCtx
    implements ProcessorSupplier.Context {
        private final int memberIndex;

        ProcSupplierCtx(JetInstance jetInstance, long jobId, long executionId, JobConfig jobConfig, ILogger logger, String vertexName, int localParallelism, int totalParallelism, int memberIndex, int memberCount, ProcessingGuarantee processingGuarantee) {
            super(jetInstance, jobId, executionId, jobConfig, logger, vertexName, localParallelism, totalParallelism, memberCount, processingGuarantee);
            this.memberIndex = memberIndex;
        }

        @Override
        public int memberIndex() {
            return this.memberIndex;
        }
    }

    static class MetaSupplierCtx
    implements ProcessorMetaSupplier.Context {
        private final JetInstance jetInstance;
        private final long jobId;
        private final long executionId;
        private final JobConfig jobConfig;
        private final ILogger logger;
        private final String vertexName;
        private final int localParallelism;
        private final int totalParallelism;
        private final int memberCount;
        private final ProcessingGuarantee processingGuarantee;

        MetaSupplierCtx(JetInstance jetInstance, long jobId, long executionId, JobConfig jobConfig, ILogger logger, String vertexName, int localParallelism, int totalParallelism, int memberCount, ProcessingGuarantee processingGuarantee) {
            this.jetInstance = jetInstance;
            this.jobId = jobId;
            this.executionId = executionId;
            this.jobConfig = jobConfig;
            this.logger = logger;
            this.vertexName = vertexName;
            this.totalParallelism = totalParallelism;
            this.localParallelism = localParallelism;
            this.memberCount = memberCount;
            this.processingGuarantee = processingGuarantee;
        }

        @Override
        @Nonnull
        public JetInstance jetInstance() {
            return this.jetInstance;
        }

        @Override
        public long jobId() {
            return this.jobId;
        }

        @Override
        public long executionId() {
            return this.executionId;
        }

        @Override
        @Nonnull
        public JobConfig jobConfig() {
            return this.jobConfig;
        }

        @Override
        public int totalParallelism() {
            return this.totalParallelism;
        }

        @Override
        public int localParallelism() {
            return this.localParallelism;
        }

        @Override
        public int memberCount() {
            return this.memberCount;
        }

        @Override
        @Nonnull
        public String vertexName() {
            return this.vertexName;
        }

        @Override
        @Nonnull
        public ILogger logger() {
            return this.logger;
        }

        @Override
        public ProcessingGuarantee processingGuarantee() {
            return this.processingGuarantee;
        }
    }
}

