/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.pipeline.ContextFactory;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class ProcessorSupplierWithContext<C>
implements ProcessorSupplier {
    static final long serialVersionUID = 1L;
    private final ContextFactory<C> contextFactory;
    private BiFunction<ContextFactory<C>, C, Processor> createProcessorFn;
    private transient C contextObject;

    private ProcessorSupplierWithContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunction<ContextFactory<C>, C, Processor> createProcessorFn) {
        this.contextFactory = contextFactory;
        this.createProcessorFn = createProcessorFn;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) {
        if (this.contextFactory.hasLocalSharing()) {
            this.contextObject = this.contextFactory.createFn().apply(context.jetInstance());
        }
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        return Stream.generate(() -> this.createProcessorFn.apply(this.contextFactory, this.contextObject)).limit(count).collect(Collectors.toList());
    }

    @Override
    public void close(Throwable error) {
        if (this.contextObject != null) {
            this.contextFactory.destroyFn().accept(this.contextObject);
        }
    }

    @Nonnull
    public static <C> ProcessorSupplier supplierWithContext(@Nonnull ContextFactory<C> contextFactory, @Nonnull BiFunctionEx<ContextFactory<C>, C, Processor> createProcessorFn) {
        return new ProcessorSupplierWithContext<C>(contextFactory, createProcessorFn);
    }
}

