/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.core.IMap;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.BiConsumerEx;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.BiPredicateEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.function.TriPredicate;
import com.hazelcast.jet.pipeline.ContextFactories;
import com.hazelcast.jet.pipeline.ContextFactory;
import com.hazelcast.jet.pipeline.GeneralStage;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface GeneralStageWithKey<T, K> {
    @Nonnull
    public FunctionEx<? super T, ? extends K> keyFn();

    @Nonnull
    public <S, R> GeneralStage<R> mapStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> var2);

    @Nonnull
    public <S> GeneralStage<T> filterStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull BiPredicateEx<? super S, ? super T> var2);

    @Nonnull
    public <S, R> GeneralStage<R> flatMapStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> var2);

    @Nonnull
    default public <A, R> GeneralStage<Map.Entry<K, R>> rollingAggregate(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        BiConsumerEx accumulateFn = aggrOp.accumulateFn();
        FunctionEx exportFn = aggrOp.exportFn();
        return this.mapStateful(aggrOp.createFn(), (acc, key, item) -> {
            accumulateFn.accept(acc, item);
            return Util.entry(key, exportFn.apply(acc));
        });
    }

    @Nonnull
    public <C, R> GeneralStage<R> mapUsingContext(@Nonnull ContextFactory<C> var1, @Nonnull TriFunction<? super C, ? super K, ? super T, ? extends R> var2);

    @Nonnull
    public <C, R> GeneralStage<R> mapUsingContextAsync(@Nonnull ContextFactory<C> var1, @Nonnull TriFunction<? super C, ? super K, ? super T, CompletableFuture<R>> var2);

    @Nonnull
    public <C> GeneralStage<T> filterUsingContext(@Nonnull ContextFactory<C> var1, @Nonnull TriPredicate<? super C, ? super K, ? super T> var2);

    @Nonnull
    public <C> GeneralStage<T> filterUsingContextAsync(@Nonnull ContextFactory<C> var1, @Nonnull TriFunction<? super C, ? super K, ? super T, CompletableFuture<Boolean>> var2);

    @Nonnull
    public <C, R> GeneralStage<R> flatMapUsingContext(@Nonnull ContextFactory<C> var1, @Nonnull TriFunction<? super C, ? super K, ? super T, ? extends Traverser<? extends R>> var2);

    @Nonnull
    public <C, R> GeneralStage<R> flatMapUsingContextAsync(@Nonnull ContextFactory<C> var1, @Nonnull TriFunction<? super C, ? super K, ? super T, CompletableFuture<Traverser<R>>> var2);

    @Nonnull
    default public <V, R> GeneralStage<R> mapUsingIMap(@Nonnull String mapName, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return this.mapUsingContextAsync(ContextFactories.iMapContext(mapName), (map, key, item) -> Util.toCompletableFuture(map.getAsync(key)).thenApply(value -> mapFn.apply((Object)item, (Object)value)));
    }

    @Nonnull
    default public <V, R> GeneralStage<R> mapUsingIMap(@Nonnull IMap<K, V> iMap, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return this.mapUsingIMap(iMap.getName(), mapFn);
    }

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull SupplierEx<Processor> var2);

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull ProcessorSupplier var2);

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull ProcessorMetaSupplier var2);
}

