/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.test;

import com.hazelcast.jet.function.ConsumerEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.jet.pipeline.test.AssertionSinks;
import com.hazelcast.spi.annotation.Beta;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Beta
public final class Assertions {
    private Assertions() {
    }

    @Nonnull
    public static <T> FunctionEx<BatchStage<T>, BatchStage<T>> assertOrdered(@Nullable String message, @Nonnull Collection<? extends T> expected) {
        return stage -> {
            stage.drainTo(AssertionSinks.assertOrdered(message, expected));
            return stage;
        };
    }

    @Nonnull
    public static <T> FunctionEx<BatchStage<T>, BatchStage<T>> assertOrdered(@Nonnull Collection<? extends T> expected) {
        return Assertions.assertOrdered(null, expected);
    }

    @Nonnull
    public static <T> FunctionEx<BatchStage<T>, BatchStage<T>> assertAnyOrder(@Nullable String message, @Nonnull Collection<? extends T> expected) {
        return stage -> {
            stage.drainTo(AssertionSinks.assertAnyOrder(message, expected));
            return stage;
        };
    }

    @Nonnull
    public static <T> FunctionEx<BatchStage<T>, BatchStage<T>> assertAnyOrder(@Nonnull Collection<? extends T> expected) {
        return Assertions.assertAnyOrder(null, expected);
    }

    @Nonnull
    public static <T> FunctionEx<BatchStage<T>, BatchStage<T>> assertContains(@Nullable String message, @Nonnull Collection<? extends T> expected) {
        return stage -> {
            stage.drainTo(AssertionSinks.assertContains(message, expected));
            return stage;
        };
    }

    @Nonnull
    public static <T> FunctionEx<BatchStage<T>, BatchStage<T>> assertContains(@Nonnull Collection<? extends T> expected) {
        return Assertions.assertContains(null, expected);
    }

    @Nonnull
    public static <T> FunctionEx<BatchStage<T>, BatchStage<T>> assertCollected(@Nonnull ConsumerEx<? super List<T>> assertFn) {
        return stage -> {
            stage.drainTo(AssertionSinks.assertCollected(assertFn));
            return stage;
        };
    }

    @Nonnull
    public static <T> FunctionEx<StreamStage<T>, StreamStage<T>> assertCollectedEventually(int timeout, @Nonnull ConsumerEx<? super List<T>> assertFn) {
        return stage -> {
            stage.drainTo(AssertionSinks.assertCollectedEventually(timeout, assertFn));
            return stage;
        };
    }
}

