/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Inbox {
    public boolean isEmpty();

    @Nullable
    public Object peek();

    @Nullable
    public Object poll();

    public void remove();

    default public <E> int drainTo(Collection<E> target) {
        return this.drainTo(target, Integer.MAX_VALUE);
    }

    default public <E> int drainTo(@Nonnull Collection<E> target, int limit) {
        Object o;
        int drained;
        for (drained = 0; drained < limit && (o = this.poll()) != null; ++drained) {
            target.add(o);
        }
        return drained;
    }

    default public <E> int drain(@Nonnull Consumer<E> consumer) {
        Object o;
        int consumed = 0;
        while ((o = this.poll()) != null) {
            consumer.accept(o);
            ++consumed;
        }
        return consumed;
    }

    public int size();
}

