/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.logging.ILogger;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface ProcessorSupplier
extends Serializable {
    default public void init(@Nonnull Context context) throws Exception {
    }

    @Nonnull
    public Collection<? extends Processor> get(int var1);

    default public void close(@Nullable Throwable error) throws Exception {
    }

    @Nonnull
    public static ProcessorSupplier of(@Nonnull SupplierEx<? extends Processor> processorSupplier) {
        return count -> Stream.generate(processorSupplier).limit(count).collect(Collectors.toList());
    }

    public static interface Context
    extends ProcessorMetaSupplier.Context {
        @Override
        @Nonnull
        public ILogger logger();

        public int memberIndex();

        @Nonnull
        public File attachedDirectory(@Nonnull String var1);

        @Nonnull
        public File attachedFile(@Nonnull String var1);
    }
}

