/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.deployment.IMapInputStream;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.IOUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public final class Contexts {
    private Contexts() {
    }

    public static class ProcCtx
    extends ProcSupplierCtx
    implements Processor.Context {
        private final int localProcessorIndex;
        private final int globalProcessorIndex;

        public ProcCtx(JetInstance instance, long jobId, long executionId, JobConfig jobConfig, ILogger logger, String vertexName, int localProcessorIndex, int globalProcessorIndex, ProcessingGuarantee processingGuarantee, int localParallelism, int memberIndex, int memberCount, ConcurrentHashMap<String, File> tempDirectories) {
            super(instance, jobId, executionId, jobConfig, logger, vertexName, localParallelism, memberCount * localParallelism, memberIndex, memberCount, processingGuarantee, tempDirectories);
            this.localProcessorIndex = localProcessorIndex;
            this.globalProcessorIndex = globalProcessorIndex;
        }

        @Override
        public int localProcessorIndex() {
            return this.localProcessorIndex;
        }

        @Override
        public int globalProcessorIndex() {
            return this.globalProcessorIndex;
        }
    }

    static class ProcSupplierCtx
    extends MetaSupplierCtx
    implements ProcessorSupplier.Context {
        private final int memberIndex;
        private final ConcurrentHashMap<String, File> tempDirectories;

        ProcSupplierCtx(JetInstance jetInstance, long jobId, long executionId, JobConfig jobConfig, ILogger logger, String vertexName, int localParallelism, int totalParallelism, int memberIndex, int memberCount, ProcessingGuarantee processingGuarantee, ConcurrentHashMap<String, File> tempDirectories) {
            super(jetInstance, jobId, executionId, jobConfig, logger, vertexName, localParallelism, totalParallelism, memberCount, processingGuarantee);
            this.memberIndex = memberIndex;
            this.tempDirectories = tempDirectories;
        }

        @Override
        public int memberIndex() {
            return this.memberIndex;
        }

        @Override
        @Nonnull
        public File attachedDirectory(@Nonnull String id) {
            Preconditions.checkHasText(id, "id cannot be null or empty");
            ResourceConfig resourceConfig = this.jobConfig().getResourceConfigs().get(id);
            if (resourceConfig == null) {
                throw new JetException(String.format("No resource is attached with ID '%s'", id));
            }
            if (resourceConfig.getResourceType() != ResourceType.DIRECTORY) {
                throw new JetException(String.format("The resource with ID '%s' is not a directory, its type is %s", new Object[]{id, resourceConfig.getResourceType()}));
            }
            return this.tempDirectories.computeIfAbsent(id, x -> this.extractFileToDisk(id));
        }

        @Override
        @Nonnull
        public File attachedFile(@Nonnull String id) {
            Preconditions.checkHasText(id, "id cannot be null or empty");
            ResourceConfig resourceConfig = this.jobConfig().getResourceConfigs().get(id);
            if (resourceConfig == null) {
                throw new JetException(String.format("No resource is attached with ID '%s'", id));
            }
            if (resourceConfig.getResourceType() != ResourceType.FILE) {
                throw new JetException(String.format("The resource with ID '%s' is not a file, its type is %s", new Object[]{id, resourceConfig.getResourceType()}));
            }
            Path fnamePath = Paths.get(resourceConfig.getUrl().getPath(), new String[0]).getFileName();
            assert (fnamePath != null) : "Resource URL" + resourceConfig.getUrl() + " has no path part";
            return new File(this.tempDirectories.computeIfAbsent(id, x -> this.extractFileToDisk(id)), fnamePath.toString());
        }

        public ConcurrentHashMap<String, File> tempDirectories() {
            return this.tempDirectories;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private File extractFileToDisk(String id) {
            IMap<String, byte[]> map = this.jetInstance().getMap(JobRepository.jobResourcesMapName(this.jobId()));
            try (IMapInputStream inputStream = new IMapInputStream(map, JobRepository.fileKeyName(id));){
                Path directory = Files.createTempDirectory(ProcSupplierCtx.tempDirPrefix(this.jetInstance().getName(), Util.idToString(this.jobId()), id), new FileAttribute[0]);
                IOUtil.unzip(inputStream, directory);
                File file = directory.toFile();
                return file;
            }
            catch (IOException e) {
                throw ExceptionUtil.rethrow(e);
            }
        }

        private static String tempDirPrefix(String jetInstanceName, String jobId, String resourceId) {
            return "jet-" + jetInstanceName + "-" + jobId + "-" + resourceId.substring(0, Math.min(32, resourceId.length())).replaceAll("[^\\w.\\-$]", "_");
        }
    }

    static class MetaSupplierCtx
    implements ProcessorMetaSupplier.Context {
        private final JetInstance jetInstance;
        private final long jobId;
        private final long executionId;
        private final JobConfig jobConfig;
        private final ILogger logger;
        private final String vertexName;
        private final int localParallelism;
        private final int totalParallelism;
        private final int memberCount;
        private final ProcessingGuarantee processingGuarantee;

        MetaSupplierCtx(JetInstance jetInstance, long jobId, long executionId, JobConfig jobConfig, ILogger logger, String vertexName, int localParallelism, int totalParallelism, int memberCount, ProcessingGuarantee processingGuarantee) {
            this.jetInstance = jetInstance;
            this.jobId = jobId;
            this.executionId = executionId;
            this.jobConfig = jobConfig;
            this.logger = logger;
            this.vertexName = vertexName;
            this.totalParallelism = totalParallelism;
            this.localParallelism = localParallelism;
            this.memberCount = memberCount;
            this.processingGuarantee = processingGuarantee;
        }

        @Override
        @Nonnull
        public JetInstance jetInstance() {
            return this.jetInstance;
        }

        @Override
        public long jobId() {
            return this.jobId;
        }

        @Override
        public long executionId() {
            return this.executionId;
        }

        @Override
        @Nonnull
        public JobConfig jobConfig() {
            return this.jobConfig;
        }

        @Override
        public int totalParallelism() {
            return this.totalParallelism;
        }

        @Override
        public int localParallelism() {
            return this.localParallelism;
        }

        @Override
        public int memberCount() {
            return this.memberCount;
        }

        @Override
        @Nonnull
        public String vertexName() {
            return this.vertexName;
        }

        @Override
        @Nonnull
        public ILogger logger() {
            return this.logger;
        }

        @Override
        public ProcessingGuarantee processingGuarantee() {
            return this.processingGuarantee;
        }
    }
}

