/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.datamodel.WindowResult;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.pipeline.JetEventFunctionAdapter;
import com.hazelcast.jet.impl.pipeline.StageWithKeyAndWindowImpl;
import com.hazelcast.jet.impl.pipeline.StreamStageImpl;
import com.hazelcast.jet.impl.pipeline.transform.WindowAggregateTransform;
import com.hazelcast.jet.pipeline.StageWithKeyAndWindow;
import com.hazelcast.jet.pipeline.StageWithWindow;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.jet.pipeline.WindowDefinition;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;

public class StageWithWindowImpl<T>
implements StageWithWindow<T> {
    private final StreamStageImpl<T> streamStage;
    private final WindowDefinition wDef;

    StageWithWindowImpl(@Nonnull StreamStageImpl<T> streamStage, @Nonnull WindowDefinition wDef) {
        this.streamStage = streamStage;
        this.wDef = wDef;
    }

    @Override
    @Nonnull
    public WindowDefinition windowDefinition() {
        return this.wDef;
    }

    @Override
    @Nonnull
    public StreamStage<T> streamStage() {
        return this.streamStage;
    }

    @Override
    @Nonnull
    public <K> StageWithKeyAndWindow<T, K> groupingKey(@Nonnull FunctionEx<? super T, ? extends K> keyFn) {
        return new StageWithKeyAndWindowImpl<T, K>(this.streamStage, keyFn, this.wDef);
    }

    @Override
    @Nonnull
    public <R> StreamStage<WindowResult<R>> aggregate(@Nonnull AggregateOperation1<? super T, ?, ? extends R> aggrOp) {
        ComputeStageImplBase.ensureJetEvents(this.streamStage, "This pipeline stage");
        return this.attachAggregate(aggrOp);
    }

    private <A, R> StreamStage<WindowResult<R>> attachAggregate(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        FunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        return (StreamStage)this.streamStage.attach(new WindowAggregateTransform(Collections.singletonList(this.streamStage.transform), this.wDef, fnAdapter.adaptAggregateOperation1(aggrOp)), fnAdapter);
    }

    @Override
    @Nonnull
    public <T1, R> StreamStage<WindowResult<R>> aggregate2(@Nonnull StreamStage<T1> stage1, @Nonnull AggregateOperation2<? super T, ? super T1, ?, ? extends R> aggrOp) {
        ComputeStageImplBase.ensureJetEvents(this.streamStage, "This pipeline stage");
        ComputeStageImplBase.ensureJetEvents((ComputeStageImplBase)((Object)stage1), "stage1");
        return this.attachAggregate2(stage1, aggrOp);
    }

    private <T1, A, R> StreamStage<WindowResult<R>> attachAggregate2(@Nonnull StreamStage<T1> stage1, @Nonnull AggregateOperation2<? super T, ? super T1, A, ? extends R> aggrOp) {
        return (StreamStage)this.streamStage.attach(new WindowAggregateTransform(Arrays.asList(this.streamStage.transform, ((StreamStageImpl)stage1).transform), this.wDef, JetEventFunctionAdapter.adaptAggregateOperation2(aggrOp)), ComputeStageImplBase.ADAPT_TO_JET_EVENT);
    }

    @Override
    @Nonnull
    public <T1, T2, R> StreamStage<WindowResult<R>> aggregate3(@Nonnull StreamStage<T1> stage1, @Nonnull StreamStage<T2> stage2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, ?, ? extends R> aggrOp) {
        ComputeStageImplBase stageImpl1 = (ComputeStageImplBase)((Object)stage1);
        ComputeStageImplBase stageImpl2 = (ComputeStageImplBase)((Object)stage2);
        ComputeStageImplBase.ensureJetEvents(this.streamStage, "This pipeline stage");
        ComputeStageImplBase.ensureJetEvents(stageImpl1, "stage1");
        ComputeStageImplBase.ensureJetEvents(stageImpl2, "stage2");
        return this.attachAggregate3(stage1, stage2, aggrOp);
    }

    private <T1, T2, K, A, R> StreamStage<WindowResult<R>> attachAggregate3(@Nonnull StreamStage<T1> stage1, @Nonnull StreamStage<T2> stage2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, A, ? extends R> aggrOp) {
        return (StreamStage)this.streamStage.attach(new WindowAggregateTransform(Arrays.asList(this.streamStage.transform, ((StreamStageImpl)stage1).transform, ((StreamStageImpl)stage2).transform), this.wDef, JetEventFunctionAdapter.adaptAggregateOperation3(aggrOp)), ComputeStageImplBase.ADAPT_TO_JET_EVENT);
    }
}

