/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.Client;
import com.hazelcast.client.ClientService;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.impl.TerminatedLifecycleService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class HazelcastClientProxy
implements HazelcastInstance,
SerializationServiceSupport {
    public volatile HazelcastClientInstanceImpl client;

    public HazelcastClientProxy(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    @Nonnull
    public Config getConfig() {
        return this.getClient().getConfig();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getClient().getName();
    }

    @Override
    @Nonnull
    public <E> Ringbuffer<E> getRingbuffer(@Nonnull String name) {
        return this.getClient().getRingbuffer(name);
    }

    @Override
    @Nonnull
    public <E> IQueue<E> getQueue(@Nonnull String name) {
        return this.getClient().getQueue(name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getTopic(@Nonnull String name) {
        return this.getClient().getTopic(name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getReliableTopic(@Nonnull String name) {
        return this.getClient().getReliableTopic(name);
    }

    @Override
    @Nonnull
    public <E> ISet<E> getSet(@Nonnull String name) {
        return this.getClient().getSet(name);
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        return this.getClient().getList(name);
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        return this.getClient().getMap(name);
    }

    @Override
    @Nonnull
    public <K, V> MultiMap<K, V> getMultiMap(@Nonnull String name) {
        return this.getClient().getMultiMap(name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        return this.getClient().getReplicatedMap(name);
    }

    @Override
    public ICacheManager getCacheManager() {
        return this.getClient().getCacheManager();
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.getClient().getCluster();
    }

    @Override
    @Nonnull
    public Client getLocalEndpoint() {
        return this.getClient().getLocalEndpoint();
    }

    @Override
    @Nonnull
    public IExecutorService getExecutorService(@Nonnull String name) {
        return this.getClient().getExecutorService(name);
    }

    @Override
    @Nonnull
    public DurableExecutorService getDurableExecutorService(@Nonnull String name) {
        return this.getClient().getDurableExecutorService(name);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.getClient().executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionOptions options, @Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.getClient().executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.getClient().newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(@Nonnull TransactionOptions options) {
        return this.getClient().newTransactionContext(options);
    }

    @Override
    @Nonnull
    public FlakeIdGenerator getFlakeIdGenerator(@Nonnull String name) {
        return this.getClient().getFlakeIdGenerator(name);
    }

    @Override
    @Nonnull
    public CardinalityEstimator getCardinalityEstimator(@Nonnull String name) {
        return this.getClient().getCardinalityEstimator(name);
    }

    @Override
    @Nonnull
    public PNCounter getPNCounter(@Nonnull String name) {
        return this.getClient().getPNCounter(name);
    }

    @Override
    @Nonnull
    public IScheduledExecutorService getScheduledExecutorService(@Nonnull String name) {
        return this.getClient().getScheduledExecutorService(name);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        return this.getClient().getDistributedObjects();
    }

    @Override
    public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener distributedObjectListener) {
        return this.getClient().addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(@Nonnull UUID registrationId) {
        return this.getClient().removeDistributedObjectListener(registrationId);
    }

    @Override
    @Nonnull
    public PartitionService getPartitionService() {
        return this.getClient().getPartitionService();
    }

    @Override
    @Nonnull
    public SplitBrainProtectionService getSplitBrainProtectionService() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public ClientService getClientService() {
        return this.getClient().getClientService();
    }

    @Override
    @Nonnull
    public LoggingService getLoggingService() {
        return this.getClient().getLoggingService();
    }

    @Override
    @Nonnull
    public LifecycleService getLifecycleService() {
        HazelcastClientInstanceImpl hz = this.client;
        return hz != null ? hz.getLifecycleService() : new TerminatedLifecycleService();
    }

    @Override
    @Nonnull
    public <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name) {
        return this.getClient().getDistributedObject(serviceName, name);
    }

    @Override
    @Nonnull
    public CPSubsystem getCPSubsystem() {
        return this.getClient().getCPSubsystem();
    }

    @Override
    @Nonnull
    public ConcurrentMap<String, Object> getUserContext() {
        return this.getClient().getUserContext();
    }

    public ClientConfig getClientConfig() {
        return this.getClient().getClientConfig();
    }

    @Override
    @Nonnull
    public HazelcastXAResource getXAResource() {
        return this.getClient().getXAResource();
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.getClient().getSerializationService();
    }

    protected HazelcastClientInstanceImpl getClient() {
        HazelcastClientInstanceImpl c = this.client;
        if (c == null || !c.getLifecycleService().isRunning()) {
            throw new HazelcastClientNotActiveException();
        }
        return c;
    }

    public String toString() {
        HazelcastClientInstanceImpl hazelcastInstance = this.client;
        if (hazelcastInstance != null) {
            return hazelcastInstance.toString();
        }
        return "HazelcastClientInstance {NOT ACTIVE}";
    }
}

