/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.operation.ForcedEviction;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.memory.NativeOutOfMemoryError;

class SingleRecordStoreForcedEviction
implements ForcedEviction {
    SingleRecordStoreForcedEviction() {
    }

    @Override
    public boolean forceEvictAndRun(MapOperation mapOperation, double evictionPercentage) {
        assert (evictionPercentage > 0.0 && evictionPercentage <= 1.0);
        RecordStore<Record> recordStore = mapOperation.recordStore;
        if (!ForcedEviction.isValid(recordStore)) {
            return false;
        }
        ILogger logger = mapOperation.logger();
        int retryCount = this.retryCount(evictionPercentage);
        for (int i = 0; i < retryCount; ++i) {
            if (logger.isFineEnabled() && logger.isFineEnabled()) {
                String msg = "Single record store forced eviction [attemptNumber: %d, mapName: %s, evictionPercentage:%.2f, partitionId: %d]";
                logger.fine(String.format(msg, i + 1, mapOperation.getName(), evictionPercentage, mapOperation.getPartitionId()));
            }
            try {
                Evictor evictor = recordStore.getMapContainer().getEvictor();
                evictor.forceEvictByPercentage(recordStore, evictionPercentage);
                mapOperation.runInternal();
                return true;
            }
            catch (NativeOutOfMemoryError e) {
                EmptyStatement.ignore(e);
                continue;
            }
        }
        return false;
    }
}

