/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.RaftGroupIdCodec;
import com.hazelcast.cp.internal.RaftGroupId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class AtomicLongCompareAndSetCodec {
    public static final int REQUEST_MESSAGE_TYPE = 590848;
    public static final int RESPONSE_MESSAGE_TYPE = 590849;
    private static final int REQUEST_EXPECTED_FIELD_OFFSET = 16;
    private static final int REQUEST_UPDATED_FIELD_OFFSET = 24;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 32;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 14;

    private AtomicLongCompareAndSetCodec() {
    }

    public static ClientMessage encodeRequest(RaftGroupId groupId, String name, long expected, long updated) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("AtomicLong.CompareAndSet");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[32], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 590848);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, expected);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, updated);
        clientMessage.add(initialFrame);
        RaftGroupIdCodec.encode(clientMessage, groupId);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.expected = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.updated = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        request.groupId = RaftGroupIdCodec.decode(iterator);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(boolean response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[14], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 590849);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 13);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public boolean response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public RaftGroupId groupId;
        public String name;
        public long expected;
        public long updated;
    }
}

