/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.RaftGroupIdCodec;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class AtomicRefApplyCodec {
    public static final int REQUEST_MESSAGE_TYPE = 655616;
    public static final int RESPONSE_MESSAGE_TYPE = 655617;
    private static final int REQUEST_RETURN_VALUE_TYPE_FIELD_OFFSET = 16;
    private static final int REQUEST_ALTER_FIELD_OFFSET = 20;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 21;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private AtomicRefApplyCodec() {
    }

    public static ClientMessage encodeRequest(RaftGroupId groupId, String name, Data function, int returnValueType, boolean alter) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("AtomicRef.Apply");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[21], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 655616);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, returnValueType);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 20, alter);
        clientMessage.add(initialFrame);
        RaftGroupIdCodec.encode(clientMessage, groupId);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, function);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.returnValueType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.alter = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 20);
        request.groupId = RaftGroupIdCodec.decode(iterator);
        request.name = StringCodec.decode(iterator);
        request.function = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(@Nullable Data response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 655617);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, response, DataCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        response.response = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        @Nullable
        public Data response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public RaftGroupId groupId;
        public String name;
        public Data function;
        public int returnValueType;
        public boolean alter;
    }
}

