/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class ScheduledExecutorSubmitToMemberCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1704704;
    public static final int RESPONSE_MESSAGE_TYPE = 1704705;
    private static final int REQUEST_MEMBER_UUID_FIELD_OFFSET = 16;
    private static final int REQUEST_TYPE_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_DELAY_IN_MILLIS_FIELD_OFFSET = 34;
    private static final int REQUEST_PERIOD_IN_MILLIS_FIELD_OFFSET = 42;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 50;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private ScheduledExecutorSubmitToMemberCodec() {
    }

    public static ClientMessage encodeRequest(String schedulerName, UUID memberUuid, byte type, String taskName, Data task, long initialDelayInMillis, long periodInMillis) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("ScheduledExecutor.SubmitToMember");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[50], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1704704);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, memberUuid);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 33, type);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 34, initialDelayInMillis);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 42, periodInMillis);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, schedulerName);
        StringCodec.encode(clientMessage, taskName);
        DataCodec.encode(clientMessage, task);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.memberUuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.type = FixedSizeTypesCodec.decodeByte(initialFrame.content, 33);
        request.initialDelayInMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 34);
        request.periodInMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 42);
        request.schedulerName = StringCodec.decode(iterator);
        request.taskName = StringCodec.decode(iterator);
        request.task = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1704705);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String schedulerName;
        public UUID memberUuid;
        public byte type;
        public String taskName;
        public Data task;
        public long initialDelayInMillis;
        public long periodInMillis;
    }
}

