/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MemberVersionCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.version.MemberVersion;
import java.util.Map;
import java.util.UUID;

public final class MemberInfoCodec {
    private static final int UUID_FIELD_OFFSET = 0;
    private static final int LITE_MEMBER_FIELD_OFFSET = 17;
    private static final int INITIAL_FRAME_SIZE = 18;

    private MemberInfoCodec() {
    }

    public static void encode(ClientMessage clientMessage, MemberInfo memberInfo) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[18]);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 0, memberInfo.getUuid());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 17, memberInfo.isLiteMember());
        clientMessage.add(initialFrame);
        AddressCodec.encode(clientMessage, memberInfo.getAddress());
        MapCodec.encode(clientMessage, memberInfo.getAttributes(), StringCodec::encode, StringCodec::encode);
        MemberVersionCodec.encode(clientMessage, memberInfo.getVersion());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MemberInfo decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        UUID uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 0);
        boolean liteMember = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 17);
        Address address = AddressCodec.decode(iterator);
        Map<String, String> attributes = MapCodec.decode(iterator, StringCodec::decode, StringCodec::decode);
        MemberVersion version = MemberVersionCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new MemberInfo(address, uuid, attributes, liteMember, version);
    }
}

