/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.AbstractLocalOperation;
import java.util.concurrent.Future;

public class RunConsoleCommandOperation
extends AbstractLocalOperation {
    private final String command;
    private final String namespace;

    public RunConsoleCommandOperation(String command, String namespace) {
        this.command = command;
        this.namespace = namespace;
    }

    @Override
    public void run() throws Exception {
        ManagementCenterService mcs = ((NodeEngineImpl)this.getNodeEngine()).getManagementCenterService();
        if (mcs == null) {
            this.sendResponse(new HazelcastException("ManagementCenterService is not initialized yet"));
            return;
        }
        ILogger logger = this.getNodeEngine().getLogger(this.getClass());
        ExecutionService executionService = this.getNodeEngine().getExecutionService();
        Future<String> future = executionService.submit("hz:mc", () -> {
            try {
                String ns = this.namespace;
                String cmd = this.command;
                if (!StringUtil.isNullOrEmpty(ns)) {
                    cmd = ns + "__" + cmd;
                }
                return mcs.runConsoleCommand(cmd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        });
        executionService.asCompletableFuture(future).whenCompleteAsync(ExceptionUtil.withTryCatch(logger, (output, error) -> this.sendResponse(error != null ? ExceptionUtil.peel(error) : output)), ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }
}

