/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Partitioner;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.Util;
import java.util.List;
import javax.annotation.Nonnull;

public class SinkTransform<T>
extends AbstractTransform {
    private static final int[] EMPTY_ORDINALS = new int[0];
    private final SinkImpl sink;
    private final int[] ordinalsToAdapt;

    public SinkTransform(@Nonnull SinkImpl sink, @Nonnull List<Transform> upstream, @Nonnull int[] ordinalsToAdapt) {
        super(sink.name(), upstream);
        this.sink = sink;
        this.ordinalsToAdapt = ordinalsToAdapt;
    }

    public SinkTransform(@Nonnull SinkImpl sink, @Nonnull Transform upstream, boolean adaptToJetEvents) {
        super(sink.name(), upstream);
        int[] nArray;
        this.sink = sink;
        if (adaptToJetEvents) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = EMPTY_ORDINALS;
        }
        this.ordinalsToAdapt = nArray;
    }

    @Override
    public void addToDag(Planner p) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.localParallelism(), FunctionAdapter.adaptingMetaSupplier(this.sink.metaSupplier(), this.ordinalsToAdapt));
        p.addEdges((Transform)this, pv.v, (e, ord) -> {
            if (this.sink.isTotalParallelismOne()) {
                e.allToOne(this.sink.name()).distributed();
            } else if (this.sink.inputPartitionKeyFunction() != null) {
                FunctionEx<Object, ?> keyFn = this.sink.inputPartitionKeyFunction();
                if (Util.arrayIndexOf(ord, this.ordinalsToAdapt) >= 0) {
                    keyFn = ComputeStageImplBase.ADAPT_TO_JET_EVENT.adaptKeyFn(keyFn);
                }
                e.partitioned(keyFn, Partitioner.defaultPartitioner());
            }
        });
    }
}

