/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.function.RunnableEx;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.MemoizingSupplier;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Util {
    private static final DateTimeFormatter LOCAL_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final Pattern TRAILING_NUMBER_PATTERN = Pattern.compile("(.*)-([0-9]+)");

    private Util() {
    }

    public static <T> Supplier<T> memoize(Supplier<T> onceSupplier) {
        return new MemoizingSupplier<T>(onceSupplier);
    }

    public static <T> Supplier<T> memoizeConcurrent(Supplier<T> onceSupplier) {
        return new ConcurrentMemoizingSupplier<T>(onceSupplier);
    }

    public static <T> T uncheckCall(@Nonnull Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static void uncheckRun(@Nonnull RunnableEx r) {
        r.run();
    }

    @CheckReturnValue
    public static boolean tryIncrement(AtomicInteger value, int increment, int limit) {
        int next;
        int prev;
        do {
            if ((next = (prev = value.get()) + increment) <= limit) continue;
            return false;
        } while (!value.compareAndSet(prev, next));
        return true;
    }

    public static JetInstance getJetInstance(NodeEngine nodeEngine) {
        return ((JetService)nodeEngine.getService("hz:impl:jetService")).getJetInstance();
    }

    public static long addClamped(long a, long b) {
        long sum = a + b;
        return Util.sumHadOverflow(a, b, sum) ? (a >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE) : sum;
    }

    public static long subtractClamped(long a, long b) {
        long diff = a - b;
        return Util.diffHadOverflow(a, b, diff) ? (a >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE) : diff;
    }

    public static boolean sumHadOverflow(long a, long b, long sum) {
        return ((a ^ sum) & (b ^ sum)) < 0L;
    }

    private static boolean diffHadOverflow(long a, long b, long diff) {
        return ((a ^ b) & (a ^ diff)) < 0L;
    }

    @Nullable
    public static <T> T checkSerializable(@Nullable T object, @Nonnull String objectName) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException('\"' + objectName + "\" must implement Serializable");
        }
        try (ObjectOutputStream os = new ObjectOutputStream(new NullOutputStream());){
            os.writeObject(object);
        }
        catch (InvalidClassException | NotSerializableException e) {
            throw new IllegalArgumentException("\"" + objectName + "\" must be serializable", e);
        }
        catch (IOException e) {
            throw new JetException(e);
        }
        return object;
    }

    @Nonnull
    public static <T> T checkNonNullAndSerializable(@Nonnull T object, @Nonnull String objectName) {
        if (object == null) {
            throw new IllegalArgumentException('\"' + objectName + "\" must not be null");
        }
        Util.checkSerializable(object, objectName);
        return object;
    }

    public static <T> Map<Integer, List<T>> distributeObjects(int count, List<T> objects) {
        Map processorToObjects = IntStream.range(0, objects.size()).mapToObj(i -> com.hazelcast.jet.Util.entry(i, objects.get(i))).collect(Collectors.groupingBy(e -> (Integer)e.getKey() % count, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        for (int i2 = 0; i2 < count; ++i2) {
            processorToObjects.putIfAbsent(i2, Collections.emptyList());
        }
        return processorToObjects;
    }

    public static int[] roundRobinPart(int objectCount, int count, int index) {
        if (objectCount < 0 || index < 0 || count < 1 || index >= count) {
            throw new IllegalArgumentException("objectCount=" + objectCount + ", count=" + count + ", index=" + index);
        }
        int[] res = new int[objectCount / count + (objectCount % count > index ? 1 : 0)];
        int i = 0;
        for (int j = index; j < objectCount; j += count) {
            res[i] = j;
            ++i;
        }
        return res;
    }

    public static String jobNameAndExecutionId(String jobName, long executionId) {
        return "job '" + jobName + "', execution " + com.hazelcast.jet.Util.idToString(executionId);
    }

    public static String jobIdAndExecutionId(long jobId, long executionId) {
        return "job " + com.hazelcast.jet.Util.idToString(jobId) + ", execution " + com.hazelcast.jet.Util.idToString(executionId);
    }

    private static ZonedDateTime toZonedDateTime(long timestamp) {
        return Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long timestamp) {
        return Util.toZonedDateTime(timestamp).toLocalDateTime();
    }

    public static String toLocalTime(long timestamp) {
        return Util.toZonedDateTime(timestamp).toLocalTime().format(LOCAL_TIME_FORMATTER);
    }

    public static int arrayIndexOf(int needle, int[] haystack) {
        for (int i = 0; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(@Nonnull Throwable exception) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(exception);
        return future;
    }

    public static void logLateEvent(ILogger logger, long currentWm, @Nonnull Object item) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        if (item instanceof JetEvent) {
            JetEvent event = (JetEvent)item;
            logger.info(String.format("Event dropped, late by %d ms. currentWatermark=%s, eventTime=%s, event=%s", currentWm - event.timestamp(), Util.toLocalTime(currentWm), Util.toLocalTime(event.timestamp()), event.payload()));
        } else {
            logger.info(String.format("Late event dropped. currentWatermark=%s, event=%s", new Watermark(currentWm), item));
        }
    }

    public static long gcd(long ... values) {
        long res = 0L;
        for (long value : values) {
            res = Util.gcd(res, value);
        }
        return res;
    }

    public static long gcd(long a, long b) {
        a = Math.abs(a);
        if ((b = Math.abs(b)) == 0L) {
            return a;
        }
        return Util.gcd(b, a % b);
    }

    public static void lazyIncrement(AtomicLongArray counters, int index) {
        Util.lazyAdd(counters, index, 1L);
    }

    public static void lazyAdd(AtomicLongArray counters, int index, long addend) {
        counters.lazySet(index, counters.get(index) + addend);
    }

    public static <E> int sum(Collection<E> collection, ToIntFunction<E> toIntF) {
        int sum = 0;
        for (E e : collection) {
            sum += toIntF.applyAsInt(e);
        }
        return sum;
    }

    public static String escapeGraphviz(String value) {
        return value.replace("\"", "\\\"");
    }

    public static CompletableFuture<Void> copyMapUsingJob(JetInstance instance, int queueSize, String sourceMap, String targetMap) {
        DAG dag = new DAG();
        Vertex source = dag.newVertex("readMap(" + sourceMap + ')', SourceProcessors.readMapP(sourceMap));
        Vertex sink = dag.newVertex("writeMap(" + targetMap + ')', SinkProcessors.writeMapP(targetMap));
        dag.edge(Edge.between(source, sink).setConfig(new EdgeConfig().setQueueSize(queueSize)));
        JobConfig jobConfig = new JobConfig().setName("copy-" + sourceMap + "-to-" + targetMap);
        return instance.newJob(dag, jobConfig).getFuture();
    }

    public static String addOrIncrementIndexInName(String name) {
        Matcher m = TRAILING_NUMBER_PATTERN.matcher(name);
        int index = 2;
        if (m.matches()) {
            try {
                int newIndex = Integer.parseInt(m.group(2)) + 1;
                if (newIndex > 2) {
                    index = newIndex;
                    name = m.group(1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return name + '-' + index;
    }

    public static String sanitizeLoggerNamePart(String name) {
        return name.replace('.', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithClassLoader(ClassLoader cl, RunnableEx action) {
        Thread currentThread = Thread.currentThread();
        ClassLoader previousCl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(cl);
        try {
            action.run();
        }
        finally {
            currentThread.setContextClassLoader(previousCl);
        }
    }

    public static ProcessingGuarantee min(ProcessingGuarantee g1, ProcessingGuarantee g2) {
        return g1.ordinal() < g2.ordinal() ? g1 : g2;
    }

    @Nonnull
    public static <T, R> List<R> toList(@Nonnull Collection<T> coll, Function<? super T, ? extends R> mapFn) {
        return coll.stream().map(mapFn).collect(Collectors.toList());
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) {
        }
    }
}

