/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.management.MCClusterMetadata;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCGetClusterMetadataCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import java.security.Permission;

public class GetClusterMetadataMessageTask
extends AbstractCallableMessageTask<MCGetClusterMetadataCodec.RequestParameters> {
    public GetClusterMetadataMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        MCClusterMetadata metadata = new MCClusterMetadata();
        metadata.setCurrentState(this.nodeEngine.getClusterService().getClusterState());
        metadata.setMemberVersion(BuildInfoProvider.getBuildInfo().getVersion());
        JetBuildInfo jetBuildInfo = BuildInfoProvider.getBuildInfo().getJetBuildInfo();
        metadata.setJetVersion(jetBuildInfo != null ? jetBuildInfo.getVersion() : null);
        metadata.setClusterTime(this.nodeEngine.getClusterService().getClusterTime());
        return metadata;
    }

    @Override
    protected MCGetClusterMetadataCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MCGetClusterMetadataCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        MCClusterMetadata metadata = (MCClusterMetadata)response;
        return MCGetClusterMetadataCodec.encodeResponse(metadata.getCurrentState().getId(), metadata.getMemberVersion(), metadata.getJetVersion(), metadata.getClusterTime());
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getClusterMetadata";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

