/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractSymmetricEncryptionConfig;
import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.CollectionConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EncryptionAtRestConfig;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.IcmpFailureDetectorConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JavaKeyStoreSecureStoreConfig;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MemcacheProtocolConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.MetricsConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RestApiConfig;
import com.hazelcast.config.RestEndpointGroup;
import com.hazelcast.config.RestServerEndpointConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecureStoreConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.UserCodeDeploymentConfig;
import com.hazelcast.config.VaultSecureStoreConfig;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.config.cp.FencedLockConfig;
import com.hazelcast.config.cp.RaftAlgorithmConfig;
import com.hazelcast.config.cp.SemaphoreConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.LdapAuthenticationConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.config.security.TlsAuthenticationConfig;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.query.impl.IndexUtils;
import com.hazelcast.splitbrainprotection.impl.ProbabilisticSplitBrainProtectionFunction;
import com.hazelcast.splitbrainprotection.impl.RecentlyActiveSplitBrainProtectionFunction;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ConfigXmlGenerator {
    protected static final String MASK_FOR_SENSITIVE_DATA = "****";
    private static final int INDENT = 5;
    private static final ILogger LOGGER = Logger.getLogger(ConfigXmlGenerator.class);
    private final boolean formatted;
    private final boolean maskSensitiveFields;

    public ConfigXmlGenerator() {
        this(true);
    }

    public ConfigXmlGenerator(boolean formatted) {
        this(formatted, true);
    }

    public ConfigXmlGenerator(boolean formatted, boolean maskSensitiveFields) {
        this.formatted = formatted;
        this.maskSensitiveFields = maskSensitiveFields;
    }

    public String generate(Config config) {
        Preconditions.isNotNull(config, "Config");
        StringBuilder xml = new StringBuilder();
        XmlGenerator gen = new XmlGenerator(xml);
        xml.append("<hazelcast ").append("xmlns=\"http://www.hazelcast.com/schema/config\"\n").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n").append("xsi:schemaLocation=\"http://www.hazelcast.com/schema/config ").append("http://www.hazelcast.com/schema/config/hazelcast-config-4.0.xsd\">");
        gen.node("license-key", this.getOrMaskValue(config.getLicenseKey()), new Object[0]).node("instance-name", config.getInstanceName(), new Object[0]).node("cluster-name", config.getClusterName(), new Object[0]);
        this.managementCenterXmlGenerator(gen, config);
        gen.appendProperties(config.getProperties());
        this.securityXmlGenerator(gen, config);
        ConfigXmlGenerator.wanReplicationXmlGenerator(gen, config);
        this.networkConfigXmlGenerator(gen, config);
        this.advancedNetworkConfigXmlGenerator(gen, config);
        ConfigXmlGenerator.replicatedMapConfigXmlGenerator(gen, config);
        ConfigXmlGenerator.mapConfigXmlGenerator(gen, config);
        ConfigXmlGenerator.cacheConfigXmlGenerator(gen, config);
        ConfigXmlGenerator.queueXmlGenerator(gen, config);
        ConfigXmlGenerator.multiMapXmlGenerator(gen, config);
        ConfigXmlGenerator.collectionXmlGenerator(gen, "list", config.getListConfigs().values());
        ConfigXmlGenerator.collectionXmlGenerator(gen, "set", config.getSetConfigs().values());
        ConfigXmlGenerator.topicXmlGenerator(gen, config);
        ConfigXmlGenerator.ringbufferXmlGenerator(gen, config);
        ConfigXmlGenerator.executorXmlGenerator(gen, config);
        ConfigXmlGenerator.durableExecutorXmlGenerator(gen, config);
        ConfigXmlGenerator.scheduledExecutorXmlGenerator(gen, config);
        ConfigXmlGenerator.partitionGroupXmlGenerator(gen, config);
        ConfigXmlGenerator.cardinalityEstimatorXmlGenerator(gen, config);
        ConfigXmlGenerator.listenerXmlGenerator(gen, config);
        ConfigXmlGenerator.serializationXmlGenerator(gen, config);
        ConfigXmlGenerator.reliableTopicXmlGenerator(gen, config);
        ConfigXmlGenerator.liteMemberXmlGenerator(gen, config);
        ConfigXmlGenerator.nativeMemoryXmlGenerator(gen, config);
        this.hotRestartXmlGenerator(gen, config);
        ConfigXmlGenerator.flakeIdGeneratorXmlGenerator(gen, config);
        ConfigXmlGenerator.crdtReplicationXmlGenerator(gen, config);
        ConfigXmlGenerator.pnCounterXmlGenerator(gen, config);
        ConfigXmlGenerator.splitBrainProtectionXmlGenerator(gen, config);
        ConfigXmlGenerator.cpSubsystemConfig(gen, config);
        ConfigXmlGenerator.metricsConfig(gen, config);
        ConfigXmlGenerator.userCodeDeploymentConfig(gen, config);
        xml.append("</hazelcast>");
        return this.format(xml.toString(), 5);
    }

    private String getOrMaskValue(String value) {
        return this.maskSensitiveFields ? MASK_FOR_SENSITIVE_DATA : value;
    }

    private void managementCenterXmlGenerator(XmlGenerator gen, Config config) {
        if (config.getManagementCenterConfig() != null) {
            ManagementCenterConfig mcConfig = config.getManagementCenterConfig();
            gen.open("management-center", "scripting-enabled", mcConfig.isScriptingEnabled());
            gen.close();
        }
    }

    private static void collectionXmlGenerator(XmlGenerator gen, String type, Collection<? extends CollectionConfig> configs) {
        if (CollectionUtil.isNotEmpty(configs)) {
            for (CollectionConfig collectionConfig : configs) {
                gen.open(type, "name", collectionConfig.getName()).node("statistics-enabled", collectionConfig.isStatisticsEnabled(), new Object[0]).node("max-size", collectionConfig.getMaxSize(), new Object[0]).node("backup-count", collectionConfig.getBackupCount(), new Object[0]).node("async-backup-count", collectionConfig.getAsyncBackupCount(), new Object[0]).node("split-brain-protection-ref", collectionConfig.getSplitBrainProtectionName(), new Object[0]);
                ConfigXmlGenerator.appendItemListenerConfigs(gen, collectionConfig.getItemListenerConfigs());
                MergePolicyConfig mergePolicyConfig = collectionConfig.getMergePolicyConfig();
                gen.node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
            }
        }
    }

    private static void replicatedMapConfigXmlGenerator(XmlGenerator gen, Config config) {
        for (ReplicatedMapConfig r : config.getReplicatedMapConfigs().values()) {
            MergePolicyConfig mergePolicyConfig = r.getMergePolicyConfig();
            gen.open("replicatedmap", "name", r.getName()).node("in-memory-format", (Object)r.getInMemoryFormat(), new Object[0]).node("async-fillup", r.isAsyncFillup(), new Object[0]).node("statistics-enabled", r.isStatisticsEnabled(), new Object[0]).node("split-brain-protection-ref", r.getSplitBrainProtectionName(), new Object[0]).node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize());
            if (!r.getListenerConfigs().isEmpty()) {
                gen.open("entry-listeners", new Object[0]);
                for (ListenerConfig lc : r.getListenerConfigs()) {
                    gen.node("entry-listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), "include-value", lc.isIncludeValue(), "local", lc.isLocal());
                }
                gen.close();
            }
            gen.close();
        }
    }

    private static void listenerXmlGenerator(XmlGenerator gen, Config config) {
        if (config.getListenerConfigs().isEmpty()) {
            return;
        }
        gen.open("listeners", new Object[0]);
        for (ListenerConfig lc : config.getListenerConfigs()) {
            gen.node("listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), new Object[0]);
        }
        gen.close();
    }

    private void securityXmlGenerator(XmlGenerator gen, Config config) {
        Map<String, RealmConfig> realms;
        SecurityConfig c = config.getSecurityConfig();
        if (c == null) {
            return;
        }
        gen.open("security", "enabled", c.isEnabled()).node("client-block-unmapped-actions", c.getClientBlockUnmappedActions(), new Object[0]);
        PermissionPolicyConfig ppc = c.getClientPolicyConfig();
        if (ppc.getClassName() != null) {
            gen.open("client-permission-policy", "class-name", ppc.getClassName()).appendProperties(ppc.getProperties()).close();
        }
        if ((realms = c.getRealmConfigs()) != null && !realms.isEmpty()) {
            gen.open("realms", new Object[0]);
            for (Map.Entry<String, RealmConfig> realmEntry : realms.entrySet()) {
                this.securityRealmGenerator(gen, realmEntry.getKey(), realmEntry.getValue());
            }
            gen.close();
        }
        ConfigXmlGenerator.addRealmReference(gen, "member-authentication", c.getMemberRealm());
        ConfigXmlGenerator.addRealmReference(gen, "client-authentication", c.getClientRealm());
        List<SecurityInterceptorConfig> sic = c.getSecurityInterceptorConfigs();
        if (!sic.isEmpty()) {
            gen.open("security-interceptors", new Object[0]);
            for (SecurityInterceptorConfig s : sic) {
                gen.open("interceptor", "class-name", s.getClassName()).close();
            }
            gen.close();
        }
        ConfigXmlGenerator.appendSecurityPermissions(gen, "client-permissions", c.getClientPermissionConfigs(), new Object[]{"on-join-operation", c.getOnJoinPermissionOperation()});
        gen.close();
    }

    private static void addRealmReference(XmlGenerator gen, String refName, String realmName) {
        if (realmName != null) {
            gen.node(refName, null, "realm", realmName);
        }
    }

    private void securityRealmGenerator(XmlGenerator gen, String name, RealmConfig c) {
        gen.open("realm", "name", name);
        if (c.isAuthenticationConfigured()) {
            gen.open("authentication", new Object[0]);
            ConfigXmlGenerator.jaasAuthenticationGenerator(gen, c.getJaasAuthenticationConfig());
            ConfigXmlGenerator.tlsAuthenticationGenerator(gen, c.getTlsAuthenticationConfig());
            ConfigXmlGenerator.ldapAuthenticationGenerator(gen, c.getLdapAuthenticationConfig());
            gen.close();
        }
        if (c.isIdentityConfigured()) {
            TokenIdentityConfig ti;
            UsernamePasswordIdentityConfig upi;
            gen.open("identity", new Object[0]);
            CredentialsFactoryConfig cf = c.getCredentialsFactoryConfig();
            if (cf != null) {
                gen.open("credentials-factory", "class-name", cf.getClassName()).appendProperties(cf.getProperties()).close();
            }
            if ((upi = c.getUsernamePasswordIdentityConfig()) != null) {
                gen.node("username-password", null, "username", upi.getUsername(), "password", this.getOrMaskValue(upi.getPassword()));
            }
            if ((ti = c.getTokenIdentityConfig()) != null) {
                gen.node("token", this.getOrMaskValue(ti.getTokenEncoded()), "encoding", ti.getEncoding().toString());
            }
            gen.close();
        }
        gen.close();
    }

    private static void tlsAuthenticationGenerator(XmlGenerator gen, TlsAuthenticationConfig c) {
        if (c == null) {
            return;
        }
        gen.node("tls", null, "roleAttribute", c.getRoleAttribute());
    }

    private static void ldapAuthenticationGenerator(XmlGenerator gen, LdapAuthenticationConfig c) {
        if (c == null) {
            return;
        }
        gen.open("ldap", new Object[0]).node("url", c.getUrl(), new Object[0]).nodeIfContents("socket-factory-class-name", c.getSocketFactoryClassName(), new Object[0]).nodeIfContents("parse-dn", c.isParseDn(), new Object[0]).nodeIfContents("role-context", c.getRoleContext(), new Object[0]).nodeIfContents("role-filter", c.getRoleFilter(), new Object[0]).nodeIfContents("role-mapping-attribute", c.getRoleMappingAttribute(), new Object[0]).nodeIfContents("role-mapping-mode", (Object)c.getRoleMappingMode(), new Object[0]).nodeIfContents("role-name-attribute", c.getRoleNameAttribute(), new Object[0]).nodeIfContents("role-recursion-max-depth", c.getRoleRecursionMaxDepth(), new Object[0]).nodeIfContents("role-search-scope", (Object)c.getRoleSearchScope(), new Object[0]).nodeIfContents("user-name-attribute", c.getUserNameAttribute(), new Object[0]).nodeIfContents("system-user-dn", c.getSystemUserDn(), new Object[0]).nodeIfContents("system-user-password", c.getSystemUserPassword(), new Object[0]).nodeIfContents("password-attribute", c.getPasswordAttribute(), new Object[0]).nodeIfContents("user-context", c.getUserContext(), new Object[0]).nodeIfContents("user-filter", c.getUserFilter(), new Object[0]).nodeIfContents("user-search-scope", (Object)c.getUserSearchScope(), new Object[0]).close();
    }

    private static void jaasAuthenticationGenerator(XmlGenerator gen, JaasAuthenticationConfig c) {
        if (c == null) {
            return;
        }
        ConfigXmlGenerator.appendLoginModules(gen, "jaas", c.getLoginModuleConfigs());
    }

    private static void appendSecurityPermissions(XmlGenerator gen, String tag, Set<PermissionConfig> cpc, Object ... attributes) {
        List<PermissionConfig.PermissionType> clusterPermTypes = Arrays.asList(PermissionConfig.PermissionType.ALL, PermissionConfig.PermissionType.CONFIG, PermissionConfig.PermissionType.TRANSACTION);
        if (!cpc.isEmpty()) {
            gen.open(tag, attributes);
            for (PermissionConfig p : cpc) {
                if (clusterPermTypes.contains((Object)p.getType())) {
                    gen.open(p.getType().getNodeName(), "principal", p.getPrincipal());
                } else {
                    gen.open(p.getType().getNodeName(), "principal", p.getPrincipal(), "name", p.getName());
                }
                if (!p.getEndpoints().isEmpty()) {
                    gen.open("endpoints", new Object[0]);
                    for (String endpoint : p.getEndpoints()) {
                        gen.node("endpoint", endpoint, new Object[0]);
                    }
                    gen.close();
                }
                if (!p.getActions().isEmpty()) {
                    gen.open("actions", new Object[0]);
                    for (String action : p.getActions()) {
                        gen.node("action", action, new Object[0]);
                    }
                    gen.close();
                }
                gen.close();
            }
            gen.close();
        }
    }

    private static void appendLoginModules(XmlGenerator gen, String tag, List<LoginModuleConfig> loginModuleConfigs) {
        gen.open(tag, new Object[0]);
        for (LoginModuleConfig lm : loginModuleConfigs) {
            ArrayList<String> attrs = new ArrayList<String>();
            attrs.add("class-name");
            attrs.add(lm.getClassName());
            if (lm.getUsage() != null) {
                attrs.add("usage");
                attrs.add(lm.getUsage().name());
            }
            gen.open("login-module", attrs.toArray()).appendProperties(lm.getProperties()).close();
        }
        gen.close();
    }

    private static void serializationXmlGenerator(XmlGenerator gen, Config config) {
        SerializationConfig c = config.getSerializationConfig();
        if (c == null) {
            return;
        }
        gen.open("serialization", new Object[0]).node("portable-version", c.getPortableVersion(), new Object[0]).node("use-native-byte-order", c.isUseNativeByteOrder(), new Object[0]).node("byte-order", c.getByteOrder(), new Object[0]).node("enable-compression", c.isEnableCompression(), new Object[0]).node("enable-shared-object", c.isEnableSharedObject(), new Object[0]).node("allow-unsafe", c.isAllowUnsafe(), new Object[0]);
        Map<Integer, String> dsfClasses = c.getDataSerializableFactoryClasses();
        Map<Integer, DataSerializableFactory> dsfImpls = c.getDataSerializableFactories();
        if (!MapUtil.isNullOrEmpty(dsfClasses) || !MapUtil.isNullOrEmpty(dsfImpls)) {
            gen.open("data-serializable-factories", new Object[0]);
            ConfigXmlGenerator.appendSerializationFactory(gen, "data-serializable-factory", dsfClasses);
            ConfigXmlGenerator.appendSerializationFactory(gen, "data-serializable-factory", dsfImpls);
            gen.close();
        }
        Map<Integer, String> portableClasses = c.getPortableFactoryClasses();
        Map<Integer, PortableFactory> portableImpls = c.getPortableFactories();
        if (!MapUtil.isNullOrEmpty(portableClasses) || !MapUtil.isNullOrEmpty(portableImpls)) {
            gen.open("portable-factories", new Object[0]);
            ConfigXmlGenerator.appendSerializationFactory(gen, "portable-factory", portableClasses);
            ConfigXmlGenerator.appendSerializationFactory(gen, "portable-factory", portableImpls);
            gen.close();
        }
        Collection<SerializerConfig> serializers = c.getSerializerConfigs();
        GlobalSerializerConfig globalSerializerConfig = c.getGlobalSerializerConfig();
        if (CollectionUtil.isNotEmpty(serializers) || globalSerializerConfig != null) {
            gen.open("serializers", new Object[0]);
            if (globalSerializerConfig != null) {
                gen.node("global-serializer", ConfigXmlGenerator.classNameOrImplClass(globalSerializerConfig.getClassName(), globalSerializerConfig.getImplementation()), "override-java-serialization", globalSerializerConfig.isOverrideJavaSerialization());
            }
            if (CollectionUtil.isNotEmpty(serializers)) {
                for (SerializerConfig serializer : serializers) {
                    gen.node("serializer", null, "type-class", ConfigXmlGenerator.classNameOrClass(serializer.getTypeClassName(), serializer.getTypeClass()), "class-name", ConfigXmlGenerator.classNameOrImplClass(serializer.getClassName(), serializer.getImplementation()));
                }
            }
            gen.close();
        }
        gen.node("check-class-def-errors", c.isCheckClassDefErrors(), new Object[0]);
        JavaSerializationFilterConfig javaSerializationFilterConfig = c.getJavaSerializationFilterConfig();
        if (javaSerializationFilterConfig != null) {
            gen.open("java-serialization-filter", "defaults-disabled", javaSerializationFilterConfig.isDefaultsDisabled());
            ConfigXmlGenerator.appendFilterList(gen, "blacklist", javaSerializationFilterConfig.getBlacklist());
            ConfigXmlGenerator.appendFilterList(gen, "whitelist", javaSerializationFilterConfig.getWhitelist());
            gen.close();
        }
        gen.close();
    }

    private static String classNameOrClass(String className, Class clazz) {
        return !StringUtil.isNullOrEmpty(className) ? className : (clazz != null ? clazz.getName() : null);
    }

    private static String classNameOrImplClass(String className, Object impl) {
        return !StringUtil.isNullOrEmpty(className) ? className : (impl != null ? impl.getClass().getName() : null);
    }

    private static void partitionGroupXmlGenerator(XmlGenerator gen, Config config) {
        PartitionGroupConfig pg = config.getPartitionGroupConfig();
        if (pg == null) {
            return;
        }
        gen.open("partition-group", new Object[]{"enabled", pg.isEnabled(), "group-type", pg.getGroupType()});
        Collection<MemberGroupConfig> configs = pg.getMemberGroupConfigs();
        if (CollectionUtil.isNotEmpty(configs)) {
            for (MemberGroupConfig mgConfig : configs) {
                gen.open("member-group", new Object[0]);
                for (String iface : mgConfig.getInterfaces()) {
                    gen.node("interface", iface, new Object[0]);
                }
                gen.close();
            }
        }
        gen.close();
    }

    private static void executorXmlGenerator(XmlGenerator gen, Config config) {
        for (ExecutorConfig ex : config.getExecutorConfigs().values()) {
            gen.open("executor-service", "name", ex.getName()).node("statistics-enabled", ex.isStatisticsEnabled(), new Object[0]).node("pool-size", ex.getPoolSize(), new Object[0]).node("queue-capacity", ex.getQueueCapacity(), new Object[0]).node("split-brain-protection-ref", ex.getSplitBrainProtectionName(), new Object[0]).close();
        }
    }

    private static void durableExecutorXmlGenerator(XmlGenerator gen, Config config) {
        for (DurableExecutorConfig ex : config.getDurableExecutorConfigs().values()) {
            gen.open("durable-executor-service", "name", ex.getName()).node("pool-size", ex.getPoolSize(), new Object[0]).node("durability", ex.getDurability(), new Object[0]).node("capacity", ex.getCapacity(), new Object[0]).node("split-brain-protection-ref", ex.getSplitBrainProtectionName(), new Object[0]).close();
        }
    }

    private static void scheduledExecutorXmlGenerator(XmlGenerator gen, Config config) {
        for (ScheduledExecutorConfig ex : config.getScheduledExecutorConfigs().values()) {
            MergePolicyConfig mergePolicyConfig = ex.getMergePolicyConfig();
            gen.open("scheduled-executor-service", "name", ex.getName()).node("pool-size", ex.getPoolSize(), new Object[0]).node("durability", ex.getDurability(), new Object[0]).node("capacity", ex.getCapacity(), new Object[0]).node("capacity-policy", ex.getCapacityPolicy().name(), new Object[0]).node("split-brain-protection-ref", ex.getSplitBrainProtectionName(), new Object[0]).node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
        }
    }

    private static void cardinalityEstimatorXmlGenerator(XmlGenerator gen, Config config) {
        for (CardinalityEstimatorConfig ex : config.getCardinalityEstimatorConfigs().values()) {
            MergePolicyConfig mergePolicyConfig = ex.getMergePolicyConfig();
            gen.open("cardinality-estimator", "name", ex.getName()).node("backup-count", ex.getBackupCount(), new Object[0]).node("async-backup-count", ex.getAsyncBackupCount(), new Object[0]).node("split-brain-protection-ref", ex.getSplitBrainProtectionName(), new Object[0]).node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
        }
    }

    private static void pnCounterXmlGenerator(XmlGenerator gen, Config config) {
        for (PNCounterConfig counterConfig : config.getPNCounterConfigs().values()) {
            gen.open("pn-counter", "name", counterConfig.getName()).node("replica-count", counterConfig.getReplicaCount(), new Object[0]).node("split-brain-protection-ref", counterConfig.getSplitBrainProtectionName(), new Object[0]).node("statistics-enabled", counterConfig.isStatisticsEnabled(), new Object[0]).close();
        }
    }

    private static void topicXmlGenerator(XmlGenerator gen, Config config) {
        for (TopicConfig t : config.getTopicConfigs().values()) {
            gen.open("topic", "name", t.getName()).node("statistics-enabled", t.isStatisticsEnabled(), new Object[0]).node("global-ordering-enabled", t.isGlobalOrderingEnabled(), new Object[0]);
            if (!t.getMessageListenerConfigs().isEmpty()) {
                gen.open("message-listeners", new Object[0]);
                for (ListenerConfig lc : t.getMessageListenerConfigs()) {
                    gen.node("message-listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), new Object[0]);
                }
                gen.close();
            }
            gen.node("multi-threading-enabled", t.isMultiThreadingEnabled(), new Object[0]);
            gen.close();
        }
    }

    private static void reliableTopicXmlGenerator(XmlGenerator gen, Config config) {
        for (ReliableTopicConfig t : config.getReliableTopicConfigs().values()) {
            gen.open("reliable-topic", "name", t.getName()).node("statistics-enabled", t.isStatisticsEnabled(), new Object[0]).node("read-batch-size", t.getReadBatchSize(), new Object[0]).node("topic-overload-policy", (Object)t.getTopicOverloadPolicy(), new Object[0]);
            if (!t.getMessageListenerConfigs().isEmpty()) {
                gen.open("message-listeners", new Object[0]);
                for (ListenerConfig lc : t.getMessageListenerConfigs()) {
                    gen.node("message-listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), new Object[0]);
                }
                gen.close();
            }
            gen.close();
        }
    }

    private static void multiMapXmlGenerator(XmlGenerator gen, Config config) {
        for (MultiMapConfig mm : config.getMultiMapConfigs().values()) {
            gen.open("multimap", "name", mm.getName()).node("backup-count", mm.getBackupCount(), new Object[0]).node("async-backup-count", mm.getAsyncBackupCount(), new Object[0]).node("statistics-enabled", mm.isStatisticsEnabled(), new Object[0]).node("binary", mm.isBinary(), new Object[0]).node("split-brain-protection-ref", mm.getSplitBrainProtectionName(), new Object[0]).node("value-collection-type", (Object)mm.getValueCollectionType(), new Object[0]);
            ConfigXmlGenerator.entryListenerConfigXmlGenerator(gen, mm.getEntryListenerConfigs());
            MergePolicyConfig mergePolicyConfig = mm.getMergePolicyConfig();
            gen.node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
        }
    }

    private static void queueXmlGenerator(XmlGenerator gen, Config config) {
        Collection<QueueConfig> qCfgs = config.getQueueConfigs().values();
        for (QueueConfig q : qCfgs) {
            gen.open("queue", "name", q.getName()).node("statistics-enabled", q.isStatisticsEnabled(), new Object[0]).node("max-size", q.getMaxSize(), new Object[0]).node("backup-count", q.getBackupCount(), new Object[0]).node("async-backup-count", q.getAsyncBackupCount(), new Object[0]).node("empty-queue-ttl", q.getEmptyQueueTtl(), new Object[0]);
            ConfigXmlGenerator.appendItemListenerConfigs(gen, q.getItemListenerConfigs());
            QueueStoreConfig storeConfig = q.getQueueStoreConfig();
            if (storeConfig != null) {
                gen.open("queue-store", "enabled", storeConfig.isEnabled()).node("class-name", ConfigXmlGenerator.classNameOrImplClass(storeConfig.getClassName(), storeConfig.getStoreImplementation()), new Object[0]).node("factory-class-name", ConfigXmlGenerator.classNameOrImplClass(storeConfig.getFactoryClassName(), storeConfig.getFactoryImplementation()), new Object[0]).appendProperties(storeConfig.getProperties()).close();
            }
            MergePolicyConfig mergePolicyConfig = q.getMergePolicyConfig();
            gen.node("split-brain-protection-ref", q.getSplitBrainProtectionName(), new Object[0]).node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
        }
    }

    private static void ringbufferXmlGenerator(XmlGenerator gen, Config config) {
        Collection<RingbufferConfig> configs = config.getRingbufferConfigs().values();
        for (RingbufferConfig rbConfig : configs) {
            gen.open("ringbuffer", "name", rbConfig.getName()).node("capacity", rbConfig.getCapacity(), new Object[0]).node("time-to-live-seconds", rbConfig.getTimeToLiveSeconds(), new Object[0]).node("backup-count", rbConfig.getBackupCount(), new Object[0]).node("async-backup-count", rbConfig.getAsyncBackupCount(), new Object[0]).node("split-brain-protection-ref", rbConfig.getSplitBrainProtectionName(), new Object[0]).node("in-memory-format", (Object)rbConfig.getInMemoryFormat(), new Object[0]);
            RingbufferStoreConfig storeConfig = rbConfig.getRingbufferStoreConfig();
            if (storeConfig != null) {
                gen.open("ringbuffer-store", "enabled", storeConfig.isEnabled()).node("class-name", ConfigXmlGenerator.classNameOrImplClass(storeConfig.getClassName(), storeConfig.getStoreImplementation()), new Object[0]).node("factory-class-name", ConfigXmlGenerator.classNameOrImplClass(storeConfig.getFactoryClassName(), storeConfig.getFactoryImplementation()), new Object[0]).appendProperties(storeConfig.getProperties());
                gen.close();
            }
            MergePolicyConfig mergePolicyConfig = rbConfig.getMergePolicyConfig();
            gen.node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).close();
        }
    }

    private static void wanReplicationXmlGenerator(XmlGenerator gen, Config config) {
        for (WanReplicationConfig wan : config.getWanReplicationConfigs().values()) {
            gen.open("wan-replication", "name", wan.getName());
            for (WanBatchPublisherConfig wanBatchPublisherConfig : wan.getBatchPublisherConfigs()) {
                ConfigXmlGenerator.wanBatchReplicationPublisherXmlGenerator(gen, wanBatchPublisherConfig);
            }
            for (WanCustomPublisherConfig wanCustomPublisherConfig : wan.getCustomPublisherConfigs()) {
                ConfigXmlGenerator.wanCustomPublisherXmlGenerator(gen, wanCustomPublisherConfig);
            }
            WanConsumerConfig consumerConfig = wan.getConsumerConfig();
            if (consumerConfig != null) {
                ConfigXmlGenerator.wanReplicationConsumerGenerator(gen, consumerConfig);
            }
            gen.close();
        }
    }

    private static void wanReplicationConsumerGenerator(XmlGenerator gen, WanConsumerConfig consumerConfig) {
        gen.open("consumer", new Object[0]);
        String consumerClassName = ConfigXmlGenerator.classNameOrImplClass(consumerConfig.getClassName(), consumerConfig.getImplementation());
        if (consumerClassName != null) {
            gen.node("class-name", consumerClassName, new Object[0]);
        }
        gen.node("persist-wan-replicated-data", consumerConfig.isPersistWanReplicatedData(), new Object[0]).appendProperties(consumerConfig.getProperties()).close();
    }

    private static void wanBatchReplicationPublisherXmlGenerator(XmlGenerator gen, WanBatchPublisherConfig c) {
        String publisherId = c.getPublisherId();
        gen.open("batch-publisher", new Object[0]);
        gen.node("cluster-name", c.getClusterName(), new Object[0]).node("batch-size", c.getBatchSize(), new Object[0]).node("batch-max-delay-millis", c.getBatchMaxDelayMillis(), new Object[0]).node("response-timeout-millis", c.getResponseTimeoutMillis(), new Object[0]).node("acknowledge-type", (Object)c.getAcknowledgeType(), new Object[0]).node("initial-publisher-state", (Object)c.getInitialPublisherState(), new Object[0]).node("snapshot-enabled", c.isSnapshotEnabled(), new Object[0]).node("idle-max-park-ns", c.getIdleMaxParkNs(), new Object[0]).node("idle-min-park-ns", c.getIdleMinParkNs(), new Object[0]).node("max-concurrent-invocations", c.getMaxConcurrentInvocations(), new Object[0]).node("discovery-period-seconds", c.getDiscoveryPeriodSeconds(), new Object[0]).node("use-endpoint-private-address", c.isUseEndpointPrivateAddress(), new Object[0]).node("queue-full-behavior", (Object)c.getQueueFullBehavior(), new Object[0]).node("max-target-endpoints", c.getMaxTargetEndpoints(), new Object[0]).node("queue-capacity", c.getQueueCapacity(), new Object[0]).appendProperties(c.getProperties());
        if (!StringUtil.isNullOrEmptyAfterTrim(publisherId)) {
            gen.node("publisher-id", publisherId, new Object[0]);
        }
        if (c.getTargetEndpoints() != null) {
            gen.node("target-endpoints", c.getTargetEndpoints(), new Object[0]);
        }
        if (c.getEndpoint() != null) {
            gen.node("endpoint", c.getEndpoint(), new Object[0]);
        }
        ConfigXmlGenerator.wanReplicationSyncGenerator(gen, c.getSyncConfig());
        ConfigXmlGenerator.aliasedDiscoveryConfigsGenerator(gen, AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(c));
        ConfigXmlGenerator.discoveryStrategyConfigXmlGenerator(gen, c.getDiscoveryConfig());
        gen.close();
    }

    private static void wanCustomPublisherXmlGenerator(XmlGenerator gen, WanCustomPublisherConfig c) {
        String publisherId = c.getPublisherId();
        gen.open("custom-publisher", new Object[0]).appendProperties(c.getProperties()).node("class-name", c.getClassName(), new Object[0]).node("publisher-id", publisherId, new Object[0]).close();
    }

    private static void wanReplicationSyncGenerator(XmlGenerator gen, WanSyncConfig c) {
        gen.open("sync", new Object[0]).node("consistency-check-strategy", (Object)c.getConsistencyCheckStrategy(), new Object[0]).close();
    }

    private void networkConfigXmlGenerator(XmlGenerator gen, Config config) {
        if (config.getAdvancedNetworkConfig().isEnabled()) {
            return;
        }
        NetworkConfig netCfg = config.getNetworkConfig();
        gen.open("network", new Object[0]).node("public-address", netCfg.getPublicAddress(), new Object[0]).node("port", netCfg.getPort(), "port-count", netCfg.getPortCount(), "auto-increment", netCfg.isPortAutoIncrement()).node("reuse-address", netCfg.isReuseAddress(), new Object[0]);
        Collection<String> outboundPortDefinitions = netCfg.getOutboundPortDefinitions();
        if (CollectionUtil.isNotEmpty(outboundPortDefinitions)) {
            gen.open("outbound-ports", new Object[0]);
            for (String def : outboundPortDefinitions) {
                gen.node("ports", def, new Object[0]);
            }
            gen.close();
        }
        JoinConfig join = netCfg.getJoin();
        gen.open("join", new Object[0]);
        ConfigXmlGenerator.multicastConfigXmlGenerator(gen, join);
        ConfigXmlGenerator.tcpConfigXmlGenerator(gen, join);
        ConfigXmlGenerator.aliasedDiscoveryConfigsGenerator(gen, AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(join));
        ConfigXmlGenerator.discoveryStrategyConfigXmlGenerator(gen, join.getDiscoveryConfig());
        gen.close();
        ConfigXmlGenerator.interfacesConfigXmlGenerator(gen, netCfg.getInterfaces());
        this.sslConfigXmlGenerator(gen, netCfg.getSSLConfig());
        ConfigXmlGenerator.socketInterceptorConfigXmlGenerator(gen, netCfg.getSocketInterceptorConfig());
        this.symmetricEncInterceptorConfigXmlGenerator(gen, netCfg.getSymmetricEncryptionConfig());
        ConfigXmlGenerator.memberAddressProviderConfigXmlGenerator(gen, netCfg.getMemberAddressProviderConfig());
        ConfigXmlGenerator.failureDetectorConfigXmlGenerator(gen, netCfg.getIcmpFailureDetectorConfig());
        ConfigXmlGenerator.restApiXmlGenerator(gen, netCfg);
        ConfigXmlGenerator.memcacheProtocolXmlGenerator(gen, netCfg);
        gen.close();
    }

    private void advancedNetworkConfigXmlGenerator(XmlGenerator gen, Config config) {
        AdvancedNetworkConfig netCfg = config.getAdvancedNetworkConfig();
        if (!netCfg.isEnabled()) {
            return;
        }
        gen.open("advanced-network", "enabled", netCfg.isEnabled());
        JoinConfig join = netCfg.getJoin();
        gen.open("join", new Object[0]);
        ConfigXmlGenerator.multicastConfigXmlGenerator(gen, join);
        ConfigXmlGenerator.tcpConfigXmlGenerator(gen, join);
        ConfigXmlGenerator.aliasedDiscoveryConfigsGenerator(gen, AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(join));
        ConfigXmlGenerator.discoveryStrategyConfigXmlGenerator(gen, join.getDiscoveryConfig());
        gen.close();
        ConfigXmlGenerator.failureDetectorConfigXmlGenerator(gen, netCfg.getIcmpFailureDetectorConfig());
        ConfigXmlGenerator.memberAddressProviderConfigXmlGenerator(gen, netCfg.getMemberAddressProviderConfig());
        for (EndpointConfig endpointConfig : netCfg.getEndpointConfigs().values()) {
            this.endpointConfigXmlGenerator(gen, endpointConfig);
        }
        gen.close();
    }

    private void endpointConfigXmlGenerator(XmlGenerator gen, EndpointConfig endpointConfig) {
        if (endpointConfig.getName() != null) {
            gen.open(this.endpointConfigElementName(endpointConfig), "name", endpointConfig.getName());
        } else {
            gen.open(this.endpointConfigElementName(endpointConfig), new Object[0]);
        }
        Collection<String> outboundPortDefinitions = endpointConfig.getOutboundPortDefinitions();
        if (CollectionUtil.isNotEmpty(outboundPortDefinitions)) {
            gen.open("outbound-ports", new Object[0]);
            for (String def : outboundPortDefinitions) {
                gen.node("ports", def, new Object[0]);
            }
            gen.close();
        }
        ConfigXmlGenerator.interfacesConfigXmlGenerator(gen, endpointConfig.getInterfaces());
        this.sslConfigXmlGenerator(gen, endpointConfig.getSSLConfig());
        ConfigXmlGenerator.socketInterceptorConfigXmlGenerator(gen, endpointConfig.getSocketInterceptorConfig());
        this.symmetricEncInterceptorConfigXmlGenerator(gen, endpointConfig.getSymmetricEncryptionConfig());
        if (endpointConfig instanceof RestServerEndpointConfig) {
            RestServerEndpointConfig rsec = (RestServerEndpointConfig)endpointConfig;
            gen.open("endpoint-groups", new Object[0]);
            for (RestEndpointGroup group : RestEndpointGroup.values()) {
                gen.node("endpoint-group", null, "name", group.name(), "enabled", rsec.isGroupEnabled(group));
            }
            gen.close();
        }
        gen.open("socket-options", new Object[0]);
        gen.node("buffer-direct", endpointConfig.isSocketBufferDirect(), new Object[0]);
        gen.node("tcp-no-delay", endpointConfig.isSocketTcpNoDelay(), new Object[0]);
        gen.node("keep-alive", endpointConfig.isSocketKeepAlive(), new Object[0]);
        gen.node("connect-timeout-seconds", endpointConfig.getSocketConnectTimeoutSeconds(), new Object[0]);
        gen.node("send-buffer-size-kb", endpointConfig.getSocketSendBufferSizeKb(), new Object[0]);
        gen.node("receive-buffer-size-kb", endpointConfig.getSocketRcvBufferSizeKb(), new Object[0]);
        gen.node("linger-seconds", endpointConfig.getSocketLingerSeconds(), new Object[0]);
        gen.close();
        if (endpointConfig instanceof ServerSocketEndpointConfig) {
            ServerSocketEndpointConfig serverSocketEndpointConfig = (ServerSocketEndpointConfig)endpointConfig;
            gen.node("port", serverSocketEndpointConfig.getPort(), "port-count", serverSocketEndpointConfig.getPortCount(), "auto-increment", serverSocketEndpointConfig.isPortAutoIncrement()).node("public-address", serverSocketEndpointConfig.getPublicAddress(), new Object[0]).node("reuse-address", serverSocketEndpointConfig.isReuseAddress(), new Object[0]);
        }
        gen.close();
    }

    private String endpointConfigElementName(EndpointConfig endpointConfig) {
        if (endpointConfig instanceof ServerSocketEndpointConfig) {
            switch (endpointConfig.getProtocolType()) {
                case REST: {
                    return "rest-server-socket-endpoint-config";
                }
                case WAN: {
                    return "wan-server-socket-endpoint-config";
                }
                case CLIENT: {
                    return "client-server-socket-endpoint-config";
                }
                case MEMBER: {
                    return "member-server-socket-endpoint-config";
                }
                case MEMCACHE: {
                    return "memcache-server-socket-endpoint-config";
                }
            }
            throw new IllegalStateException("Not recognised protocol type");
        }
        return "wan-endpoint-config";
    }

    private static void mapConfigXmlGenerator(XmlGenerator gen, Config config) {
        Collection<MapConfig> mapConfigs = config.getMapConfigs().values();
        for (MapConfig m : mapConfigs) {
            String cacheDeserializedVal = m.getCacheDeserializedValues() != null ? m.getCacheDeserializedValues().name().replaceAll("_", "-") : null;
            MergePolicyConfig mergePolicyConfig = m.getMergePolicyConfig();
            gen.open("map", "name", m.getName()).node("in-memory-format", (Object)m.getInMemoryFormat(), new Object[0]).node("statistics-enabled", m.isStatisticsEnabled(), new Object[0]).node("cache-deserialized-values", cacheDeserializedVal, new Object[0]).node("backup-count", m.getBackupCount(), new Object[0]).node("async-backup-count", m.getAsyncBackupCount(), new Object[0]).node("time-to-live-seconds", m.getTimeToLiveSeconds(), new Object[0]).node("max-idle-seconds", m.getMaxIdleSeconds(), new Object[0]).node("merge-policy", mergePolicyConfig.getPolicy(), "batch-size", mergePolicyConfig.getBatchSize()).node("split-brain-protection-ref", m.getSplitBrainProtectionName(), new Object[0]).node("read-backup-data", m.isReadBackupData(), new Object[0]).node("metadata-policy", (Object)m.getMetadataPolicy(), new Object[0]);
            ConfigXmlGenerator.evictionConfigXmlGenerator(gen, m.getEvictionConfig());
            ConfigXmlGenerator.appendMerkleTreeConfig(gen, m.getMerkleTreeConfig());
            ConfigXmlGenerator.appendEventJournalConfig(gen, m.getEventJournalConfig());
            ConfigXmlGenerator.appendHotRestartConfig(gen, m.getHotRestartConfig());
            ConfigXmlGenerator.mapStoreConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.mapNearCacheConfigXmlGenerator(gen, m.getNearCacheConfig());
            ConfigXmlGenerator.wanReplicationConfigXmlGenerator(gen, m.getWanReplicationRef());
            ConfigXmlGenerator.indexConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.attributeConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.entryListenerConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.mapPartitionLostListenerConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.mapPartitionStrategyConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.mapQueryCachesConfigXmlGenerator(gen, m);
            gen.close();
        }
    }

    private static void appendMerkleTreeConfig(XmlGenerator gen, MerkleTreeConfig c) {
        gen.open("merkle-tree", "enabled", c.isEnabled()).node("depth", c.getDepth(), new Object[0]).close();
    }

    private static void appendHotRestartConfig(XmlGenerator gen, HotRestartConfig m) {
        gen.open("hot-restart", "enabled", m != null && m.isEnabled()).node("fsync", m != null && m.isFsync(), new Object[0]).close();
    }

    private static void appendEventJournalConfig(XmlGenerator gen, EventJournalConfig c) {
        gen.open("event-journal", "enabled", c.isEnabled()).node("capacity", c.getCapacity(), new Object[0]).node("time-to-live-seconds", c.getTimeToLiveSeconds(), new Object[0]).close();
    }

    private static void cacheConfigXmlGenerator(XmlGenerator gen, Config config) {
        for (CacheSimpleConfig c : config.getCacheConfigs().values()) {
            gen.open("cache", "name", c.getName());
            if (c.getKeyType() != null) {
                gen.node("key-type", null, "class-name", c.getKeyType());
            }
            if (c.getValueType() != null) {
                gen.node("value-type", null, "class-name", c.getValueType());
            }
            gen.node("statistics-enabled", c.isStatisticsEnabled(), new Object[0]).node("management-enabled", c.isManagementEnabled(), new Object[0]).node("read-through", c.isReadThrough(), new Object[0]).node("write-through", c.isWriteThrough(), new Object[0]);
            ConfigXmlGenerator.checkAndFillCacheLoaderFactoryConfigXml(gen, c.getCacheLoaderFactory());
            ConfigXmlGenerator.checkAndFillCacheLoaderConfigXml(gen, c.getCacheLoader());
            ConfigXmlGenerator.checkAndFillCacheWriterFactoryConfigXml(gen, c.getCacheWriterFactory());
            ConfigXmlGenerator.checkAndFillCacheWriterConfigXml(gen, c.getCacheWriter());
            ConfigXmlGenerator.cacheExpiryPolicyFactoryConfigXmlGenerator(gen, c.getExpiryPolicyFactoryConfig());
            gen.open("cache-entry-listeners", new Object[0]);
            for (CacheSimpleEntryListenerConfig el : c.getCacheEntryListeners()) {
                gen.open("cache-entry-listener", "old-value-required", el.isOldValueRequired(), "synchronous", el.isSynchronous()).node("cache-entry-listener-factory", null, "class-name", el.getCacheEntryListenerFactory()).node("cache-entry-event-filter-factory", null, "class-name", el.getCacheEntryEventFilterFactory()).close();
            }
            gen.close().node("in-memory-format", (Object)c.getInMemoryFormat(), new Object[0]).node("backup-count", c.getBackupCount(), new Object[0]).node("async-backup-count", c.getAsyncBackupCount(), new Object[0]);
            ConfigXmlGenerator.evictionConfigXmlGenerator(gen, c.getEvictionConfig());
            ConfigXmlGenerator.wanReplicationConfigXmlGenerator(gen, c.getWanReplicationRef());
            gen.node("split-brain-protection-ref", c.getSplitBrainProtectionName(), new Object[0]);
            ConfigXmlGenerator.cachePartitionLostListenerConfigXmlGenerator(gen, c.getPartitionLostListenerConfigs());
            gen.node("merge-policy", c.getMergePolicyConfig().getPolicy(), new Object[0]);
            ConfigXmlGenerator.appendEventJournalConfig(gen, c.getEventJournalConfig());
            ConfigXmlGenerator.appendHotRestartConfig(gen, c.getHotRestartConfig());
            gen.node("disable-per-entry-invalidation-events", c.isDisablePerEntryInvalidationEvents(), new Object[0]).close();
        }
    }

    private static void checkAndFillCacheWriterFactoryConfigXml(XmlGenerator gen, String cacheWriter) {
        if (StringUtil.isNullOrEmpty(cacheWriter)) {
            return;
        }
        gen.node("cache-writer-factory", null, "class-name", cacheWriter);
    }

    private static void checkAndFillCacheWriterConfigXml(XmlGenerator gen, String cacheWriter) {
        if (StringUtil.isNullOrEmpty(cacheWriter)) {
            return;
        }
        gen.node("cache-writer", null, "class-name", cacheWriter);
    }

    private static void checkAndFillCacheLoaderFactoryConfigXml(XmlGenerator gen, String cacheLoader) {
        if (StringUtil.isNullOrEmpty(cacheLoader)) {
            return;
        }
        gen.node("cache-loader-factory", null, "class-name", cacheLoader);
    }

    private static void checkAndFillCacheLoaderConfigXml(XmlGenerator gen, String cacheLoader) {
        if (StringUtil.isNullOrEmpty(cacheLoader)) {
            return;
        }
        gen.node("cache-loader", null, "class-name", cacheLoader);
    }

    private static void cacheExpiryPolicyFactoryConfigXmlGenerator(XmlGenerator gen, CacheSimpleConfig.ExpiryPolicyFactoryConfig config) {
        if (config == null) {
            return;
        }
        if (!StringUtil.isNullOrEmpty(config.getClassName())) {
            gen.node("expiry-policy-factory", null, "class-name", config.getClassName());
        } else {
            CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedConfig = config.getTimedExpiryPolicyFactoryConfig();
            if (timedConfig != null && timedConfig.getExpiryPolicyType() != null && timedConfig.getDurationConfig() != null) {
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig duration = timedConfig.getDurationConfig();
                gen.open("expiry-policy-factory", new Object[0]).node("timed-expiry-policy-factory", null, new Object[]{"expiry-policy-type", timedConfig.getExpiryPolicyType(), "duration-amount", duration.getDurationAmount(), "time-unit", duration.getTimeUnit().name()}).close();
            }
        }
    }

    private static void cachePartitionLostListenerConfigXmlGenerator(XmlGenerator gen, List<CachePartitionLostListenerConfig> configs) {
        if (configs.isEmpty()) {
            return;
        }
        gen.open("partition-lost-listeners", new Object[0]);
        for (CachePartitionLostListenerConfig c : configs) {
            gen.node("partition-lost-listener", ConfigXmlGenerator.classNameOrImplClass(c.getClassName(), c.getImplementation()), new Object[0]);
        }
        gen.close();
    }

    private static void mapPartitionStrategyConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        if (m.getPartitioningStrategyConfig() != null) {
            PartitioningStrategyConfig psc = m.getPartitioningStrategyConfig();
            gen.node("partition-strategy", ConfigXmlGenerator.classNameOrImplClass(psc.getPartitioningStrategyClass(), psc.getPartitioningStrategy()), new Object[0]);
        }
    }

    private static void mapQueryCachesConfigXmlGenerator(XmlGenerator gen, MapConfig mapConfig) {
        List<QueryCacheConfig> queryCacheConfigs = mapConfig.getQueryCacheConfigs();
        if (queryCacheConfigs != null && !queryCacheConfigs.isEmpty()) {
            gen.open("query-caches", new Object[0]);
            for (QueryCacheConfig queryCacheConfig : queryCacheConfigs) {
                gen.open("query-cache", "name", queryCacheConfig.getName());
                gen.node("include-value", queryCacheConfig.isIncludeValue(), new Object[0]);
                gen.node("in-memory-format", (Object)queryCacheConfig.getInMemoryFormat(), new Object[0]);
                gen.node("populate", queryCacheConfig.isPopulate(), new Object[0]);
                gen.node("coalesce", queryCacheConfig.isCoalesce(), new Object[0]);
                gen.node("delay-seconds", queryCacheConfig.getDelaySeconds(), new Object[0]);
                gen.node("batch-size", queryCacheConfig.getBatchSize(), new Object[0]);
                gen.node("buffer-size", queryCacheConfig.getBufferSize(), new Object[0]);
                ConfigXmlGenerator.evictionConfigXmlGenerator(gen, queryCacheConfig.getEvictionConfig());
                IndexUtils.generateXml(gen, queryCacheConfig.getIndexConfigs());
                ConfigXmlGenerator.mapQueryCachePredicateConfigXmlGenerator(gen, queryCacheConfig);
                ConfigXmlGenerator.entryListenerConfigXmlGenerator(gen, queryCacheConfig.getEntryListenerConfigs());
                gen.close();
            }
            gen.close();
        }
    }

    private static void mapQueryCachePredicateConfigXmlGenerator(XmlGenerator gen, QueryCacheConfig queryCacheConfig) {
        PredicateConfig predicateConfig = queryCacheConfig.getPredicateConfig();
        String type = predicateConfig.getClassName() != null ? "class-name" : "sql";
        String content = predicateConfig.getClassName() != null ? predicateConfig.getClassName() : predicateConfig.getSql();
        gen.node("predicate", content, "type", type);
    }

    private static void entryListenerConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        ConfigXmlGenerator.entryListenerConfigXmlGenerator(gen, m.getEntryListenerConfigs());
    }

    private static void entryListenerConfigXmlGenerator(XmlGenerator gen, List<EntryListenerConfig> entryListenerConfigs) {
        if (!entryListenerConfigs.isEmpty()) {
            gen.open("entry-listeners", new Object[0]);
            for (EntryListenerConfig lc : entryListenerConfigs) {
                gen.node("entry-listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), "include-value", lc.isIncludeValue(), "local", lc.isLocal());
            }
            gen.close();
        }
    }

    private static void mapPartitionLostListenerConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        if (!m.getPartitionLostListenerConfigs().isEmpty()) {
            gen.open("partition-lost-listeners", new Object[0]);
            for (MapPartitionLostListenerConfig c : m.getPartitionLostListenerConfigs()) {
                gen.node("partition-lost-listener", ConfigXmlGenerator.classNameOrImplClass(c.getClassName(), c.getImplementation()), new Object[0]);
            }
            gen.close();
        }
    }

    private static void indexConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        IndexUtils.generateXml(gen, m.getIndexConfigs());
    }

    private static void attributeConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        if (!m.getAttributeConfigs().isEmpty()) {
            gen.open("attributes", new Object[0]);
            for (AttributeConfig attributeCfg : m.getAttributeConfigs()) {
                gen.node("attribute", attributeCfg.getName(), "extractor-class-name", attributeCfg.getExtractorClassName());
            }
            gen.close();
        }
    }

    private static void wanReplicationConfigXmlGenerator(XmlGenerator gen, WanReplicationRef wan) {
        if (wan != null) {
            List<String> filters;
            gen.open("wan-replication-ref", "name", wan.getName());
            String mergePolicy = wan.getMergePolicyClassName();
            if (!StringUtil.isNullOrEmpty(mergePolicy)) {
                gen.node("merge-policy-class-name", mergePolicy, new Object[0]);
            }
            if (CollectionUtil.isNotEmpty(filters = wan.getFilters())) {
                gen.open("filters", new Object[0]);
                for (String f : filters) {
                    gen.node("filter-impl", f, new Object[0]);
                }
                gen.close();
            }
            gen.node("republishing-enabled", wan.isRepublishingEnabled(), new Object[0]).close();
        }
    }

    private static void mapStoreConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        if (m.getMapStoreConfig() != null) {
            MapStoreConfig s = m.getMapStoreConfig();
            String clazz = s.getImplementation() != null ? s.getImplementation().getClass().getName() : s.getClassName();
            String factoryClass = s.getFactoryImplementation() != null ? s.getFactoryImplementation().getClass().getName() : s.getFactoryClassName();
            MapStoreConfig.InitialLoadMode initialMode = s.getInitialLoadMode();
            gen.open("map-store", "enabled", s.isEnabled(), "initial-mode", initialMode.toString()).node("class-name", clazz, new Object[0]).node("factory-class-name", factoryClass, new Object[0]).node("write-delay-seconds", s.getWriteDelaySeconds(), new Object[0]).node("write-batch-size", s.getWriteBatchSize(), new Object[0]).appendProperties(s.getProperties()).close();
        }
    }

    private static void mapNearCacheConfigXmlGenerator(XmlGenerator gen, NearCacheConfig n) {
        if (n != null) {
            if (n.getName() != null) {
                gen.open("near-cache", "name", n.getName());
            } else {
                gen.open("near-cache", new Object[0]);
            }
            gen.node("in-memory-format", (Object)n.getInMemoryFormat(), new Object[0]).node("invalidate-on-change", n.isInvalidateOnChange(), new Object[0]).node("time-to-live-seconds", n.getTimeToLiveSeconds(), new Object[0]).node("max-idle-seconds", n.getMaxIdleSeconds(), new Object[0]).node("serialize-keys", n.isSerializeKeys(), new Object[0]).node("cache-local-entries", n.isCacheLocalEntries(), new Object[0]);
            ConfigXmlGenerator.evictionConfigXmlGenerator(gen, n.getEvictionConfig());
            gen.close();
        }
    }

    private static void evictionConfigXmlGenerator(XmlGenerator gen, EvictionConfig e) {
        if (e == null) {
            return;
        }
        String comparatorClassName = !StringUtil.isNullOrEmpty(e.getComparatorClassName()) ? e.getComparatorClassName() : null;
        gen.node("eviction", null, new Object[]{"size", e.getSize(), "max-size-policy", e.getMaxSizePolicy(), "eviction-policy", e.getEvictionPolicy(), "comparator-class-name", comparatorClassName});
    }

    private static void multicastConfigXmlGenerator(XmlGenerator gen, JoinConfig join) {
        MulticastConfig mcConfig = join.getMulticastConfig();
        gen.open("multicast", "enabled", mcConfig.isEnabled(), "loopbackModeEnabled", mcConfig.isLoopbackModeEnabled()).node("multicast-group", mcConfig.getMulticastGroup(), new Object[0]).node("multicast-port", mcConfig.getMulticastPort(), new Object[0]).node("multicast-timeout-seconds", mcConfig.getMulticastTimeoutSeconds(), new Object[0]).node("multicast-time-to-live", mcConfig.getMulticastTimeToLive(), new Object[0]);
        if (!mcConfig.getTrustedInterfaces().isEmpty()) {
            gen.open("trusted-interfaces", new Object[0]);
            for (String trustedInterface : mcConfig.getTrustedInterfaces()) {
                gen.node("interface", trustedInterface, new Object[0]);
            }
            gen.close();
        }
        gen.close();
    }

    private static void tcpConfigXmlGenerator(XmlGenerator gen, JoinConfig join) {
        TcpIpConfig c = join.getTcpIpConfig();
        gen.open("tcp-ip", "enabled", c.isEnabled(), "connection-timeout-seconds", c.getConnectionTimeoutSeconds()).open("member-list", new Object[0]);
        for (String m : c.getMembers()) {
            gen.node("member", m, new Object[0]);
        }
        gen.close().node("required-member", c.getRequiredMember(), new Object[0]).close();
    }

    private static void aliasedDiscoveryConfigsGenerator(XmlGenerator gen, List<AliasedDiscoveryConfig<?>> configs) {
        if (configs == null) {
            return;
        }
        for (AliasedDiscoveryConfig<?> c : configs) {
            gen.open(AliasedDiscoveryConfigUtils.tagFor(c), "enabled", c.isEnabled());
            if (c.isUsePublicIp()) {
                gen.node("use-public-ip", "true", new Object[0]);
            }
            for (String key : c.getProperties().keySet()) {
                gen.node(key, c.getProperties().get(key), new Object[0]);
            }
            gen.close();
        }
    }

    private static void discoveryStrategyConfigXmlGenerator(XmlGenerator gen, DiscoveryConfig c) {
        Collection<DiscoveryStrategyConfig> configs;
        if (c == null) {
            return;
        }
        gen.open("discovery-strategies", new Object[0]);
        String nodeFilterClass = ConfigXmlGenerator.classNameOrImplClass(c.getNodeFilterClass(), c.getNodeFilter());
        if (nodeFilterClass != null) {
            gen.node("node-filter", null, "class", nodeFilterClass);
        }
        if (CollectionUtil.isNotEmpty(configs = c.getDiscoveryStrategyConfigs())) {
            for (DiscoveryStrategyConfig config : configs) {
                gen.open("discovery-strategy", "class", ConfigXmlGenerator.classNameOrImplClass(config.getClassName(), config.getDiscoveryStrategyFactory()), "enabled", "true").appendProperties(config.getProperties()).close();
            }
        }
        gen.close();
    }

    private static void interfacesConfigXmlGenerator(XmlGenerator gen, InterfacesConfig interfaces) {
        gen.open("interfaces", "enabled", interfaces.isEnabled());
        for (String i : interfaces.getInterfaces()) {
            gen.node("interface", i, new Object[0]);
        }
        gen.close();
    }

    private void sslConfigXmlGenerator(XmlGenerator gen, SSLConfig ssl) {
        gen.open("ssl", "enabled", ssl != null && ssl.isEnabled());
        if (ssl != null) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)ssl.getProperties());
            if (this.maskSensitiveFields && props.containsKey("trustStorePassword")) {
                props.setProperty("trustStorePassword", MASK_FOR_SENSITIVE_DATA);
            }
            if (this.maskSensitiveFields && props.containsKey("keyStorePassword")) {
                props.setProperty("keyStorePassword", MASK_FOR_SENSITIVE_DATA);
            }
            gen.node("factory-class-name", ConfigXmlGenerator.classNameOrImplClass(ssl.getFactoryClassName(), ssl.getFactoryImplementation()), new Object[0]).appendProperties(props);
        }
        gen.close();
    }

    private static void socketInterceptorConfigXmlGenerator(XmlGenerator gen, SocketInterceptorConfig socket) {
        gen.open("socket-interceptor", "enabled", socket != null && socket.isEnabled());
        if (socket != null) {
            gen.node("class-name", ConfigXmlGenerator.classNameOrImplClass(socket.getClassName(), socket.getImplementation()), new Object[0]).appendProperties(socket.getProperties());
        }
        gen.close();
    }

    private void commonSymmetricEncInterceptorConfigXmlBodyGenerator(XmlGenerator gen, AbstractSymmetricEncryptionConfig sec) {
        if (sec == null) {
            return;
        }
        gen.node("algorithm", sec.getAlgorithm(), new Object[0]).node("salt", this.getOrMaskValue(sec.getSalt()), new Object[0]);
    }

    private void symmetricEncInterceptorConfigXmlGenerator(XmlGenerator gen, SymmetricEncryptionConfig sec) {
        if (sec == null) {
            return;
        }
        gen.open("symmetric-encryption", "enabled", sec.isEnabled());
        this.commonSymmetricEncInterceptorConfigXmlBodyGenerator(gen, sec);
        gen.node("password", this.getOrMaskValue(sec.getPassword()), new Object[0]).node("iteration-count", sec.getIterationCount(), new Object[0]);
        gen.close();
    }

    private static void memberAddressProviderConfigXmlGenerator(XmlGenerator gen, MemberAddressProviderConfig memberAddressProviderConfig) {
        if (memberAddressProviderConfig == null) {
            return;
        }
        String className = ConfigXmlGenerator.classNameOrImplClass(memberAddressProviderConfig.getClassName(), memberAddressProviderConfig.getImplementation());
        if (StringUtil.isNullOrEmpty(className)) {
            return;
        }
        gen.open("member-address-provider", "enabled", memberAddressProviderConfig.isEnabled()).node("class-name", className, new Object[0]).appendProperties(memberAddressProviderConfig.getProperties()).close();
    }

    private static void failureDetectorConfigXmlGenerator(XmlGenerator gen, IcmpFailureDetectorConfig icmpFailureDetectorConfig) {
        if (icmpFailureDetectorConfig == null) {
            return;
        }
        gen.open("failure-detector", new Object[0]);
        gen.open("icmp", "enabled", icmpFailureDetectorConfig.isEnabled()).node("ttl", icmpFailureDetectorConfig.getTtl(), new Object[0]).node("interval-milliseconds", icmpFailureDetectorConfig.getIntervalMilliseconds(), new Object[0]).node("max-attempts", icmpFailureDetectorConfig.getMaxAttempts(), new Object[0]).node("timeout-milliseconds", icmpFailureDetectorConfig.getTimeoutMilliseconds(), new Object[0]).node("fail-fast-on-startup", icmpFailureDetectorConfig.isFailFastOnStartup(), new Object[0]).node("parallel-mode", icmpFailureDetectorConfig.isParallelMode(), new Object[0]).close();
        gen.close();
    }

    private void hotRestartXmlGenerator(XmlGenerator gen, Config config) {
        HotRestartPersistenceConfig hrCfg = config.getHotRestartPersistenceConfig();
        if (hrCfg == null) {
            gen.node("hot-restart-persistence", "enabled", "false");
            return;
        }
        gen.open("hot-restart-persistence", "enabled", hrCfg.isEnabled()).node("base-dir", hrCfg.getBaseDir().getAbsolutePath(), new Object[0]);
        if (hrCfg.getBackupDir() != null) {
            gen.node("backup-dir", hrCfg.getBackupDir().getAbsolutePath(), new Object[0]);
        }
        gen.node("parallelism", hrCfg.getParallelism(), new Object[0]).node("validation-timeout-seconds", hrCfg.getValidationTimeoutSeconds(), new Object[0]).node("data-load-timeout-seconds", hrCfg.getDataLoadTimeoutSeconds(), new Object[0]).node("cluster-data-recovery-policy", (Object)hrCfg.getClusterDataRecoveryPolicy(), new Object[0]).node("auto-remove-stale-data", hrCfg.isAutoRemoveStaleData(), new Object[0]);
        this.encryptionAtRestXmlGenerator(gen, hrCfg.getEncryptionAtRestConfig());
        gen.close();
    }

    private void encryptionAtRestXmlGenerator(XmlGenerator gen, EncryptionAtRestConfig encryptionAtRestConfig) {
        if (encryptionAtRestConfig == null) {
            gen.node("encryption-at-rest", "enabled", "false");
            return;
        }
        gen.open("encryption-at-rest", "enabled", encryptionAtRestConfig.isEnabled()).node("key-size", encryptionAtRestConfig.getKeySize(), new Object[0]);
        this.commonSymmetricEncInterceptorConfigXmlBodyGenerator(gen, encryptionAtRestConfig);
        this.secureStoreXmlGenerator(gen, encryptionAtRestConfig.getSecureStoreConfig());
        gen.close();
    }

    private void secureStoreXmlGenerator(XmlGenerator gen, SecureStoreConfig secureStoreConfig) {
        if (secureStoreConfig != null) {
            gen.open("secure-store", new Object[0]);
            if (secureStoreConfig instanceof JavaKeyStoreSecureStoreConfig) {
                this.javaKeyStoreSecureStoreXmlGenerator(gen, (JavaKeyStoreSecureStoreConfig)secureStoreConfig);
            } else if (secureStoreConfig instanceof VaultSecureStoreConfig) {
                this.vaultSecureStoreXmlGenerator(gen, (VaultSecureStoreConfig)secureStoreConfig);
            }
            gen.close();
        }
    }

    private void javaKeyStoreSecureStoreXmlGenerator(XmlGenerator gen, JavaKeyStoreSecureStoreConfig secureStoreConfig) {
        gen.open("keystore", new Object[0]).node("path", secureStoreConfig.getPath().getAbsolutePath(), new Object[0]).node("type", secureStoreConfig.getType(), new Object[0]).node("password", this.getOrMaskValue(secureStoreConfig.getPassword()), new Object[0]).node("polling-interval", secureStoreConfig.getPollingInterval(), new Object[0]).node("current-key-alias", secureStoreConfig.getCurrentKeyAlias(), new Object[0]);
        gen.close();
    }

    private void vaultSecureStoreXmlGenerator(XmlGenerator gen, VaultSecureStoreConfig secureStoreConfig) {
        gen.open("vault", new Object[0]).node("address", secureStoreConfig.getAddress(), new Object[0]).node("secret-path", secureStoreConfig.getSecretPath(), new Object[0]).node("token", this.getOrMaskValue(secureStoreConfig.getToken()), new Object[0]).node("polling-interval", secureStoreConfig.getPollingInterval(), new Object[0]);
        this.sslConfigXmlGenerator(gen, secureStoreConfig.getSSLConfig());
        gen.close();
    }

    private static void flakeIdGeneratorXmlGenerator(XmlGenerator gen, Config config) {
        for (FlakeIdGeneratorConfig m : config.getFlakeIdGeneratorConfigs().values()) {
            gen.open("flake-id-generator", "name", m.getName()).node("prefetch-count", m.getPrefetchCount(), new Object[0]).node("prefetch-validity-millis", m.getPrefetchValidityMillis(), new Object[0]).node("epoch-start", m.getEpochStart(), new Object[0]).node("node-id-offset", m.getNodeIdOffset(), new Object[0]).node("bits-sequence", m.getBitsSequence(), new Object[0]).node("bits-node-id", m.getBitsNodeId(), new Object[0]).node("allowed-future-millis", m.getAllowedFutureMillis(), new Object[0]).node("statistics-enabled", m.isStatisticsEnabled(), new Object[0]);
            gen.close();
        }
    }

    private static void crdtReplicationXmlGenerator(XmlGenerator gen, Config config) {
        CRDTReplicationConfig replicationConfig = config.getCRDTReplicationConfig();
        gen.open("crdt-replication", new Object[0]);
        if (replicationConfig != null) {
            gen.node("replication-period-millis", replicationConfig.getReplicationPeriodMillis(), new Object[0]).node("max-concurrent-replication-targets", replicationConfig.getMaxConcurrentReplicationTargets(), new Object[0]);
        }
        gen.close();
    }

    private static void splitBrainProtectionXmlGenerator(XmlGenerator gen, Config config) {
        for (SplitBrainProtectionConfig splitBrainProtectionConfig : config.getSplitBrainProtectionConfigs().values()) {
            gen.open("split-brain-protection", "name", splitBrainProtectionConfig.getName(), "enabled", splitBrainProtectionConfig.isEnabled()).node("minimum-cluster-size", splitBrainProtectionConfig.getMinimumClusterSize(), new Object[0]).node("protect-on", (Object)splitBrainProtectionConfig.getProtectOn(), new Object[0]);
            if (!splitBrainProtectionConfig.getListenerConfigs().isEmpty()) {
                gen.open("listeners", new Object[0]);
                for (SplitBrainProtectionListenerConfig listenerConfig : splitBrainProtectionConfig.getListenerConfigs()) {
                    gen.node("listener", ConfigXmlGenerator.classNameOrImplClass(listenerConfig.getClassName(), listenerConfig.getImplementation()), new Object[0]);
                }
                gen.close();
            }
            ConfigXmlGenerator.handleSplitBrainProtectionFunction(gen, splitBrainProtectionConfig);
            gen.close();
        }
    }

    private static void cpSubsystemConfig(XmlGenerator gen, Config config) {
        CPSubsystemConfig cpSubsystemConfig = config.getCPSubsystemConfig();
        gen.open("cp-subsystem", new Object[0]).node("cp-member-count", cpSubsystemConfig.getCPMemberCount(), new Object[0]).node("group-size", cpSubsystemConfig.getGroupSize(), new Object[0]).node("session-time-to-live-seconds", cpSubsystemConfig.getSessionTimeToLiveSeconds(), new Object[0]).node("session-heartbeat-interval-seconds", cpSubsystemConfig.getSessionHeartbeatIntervalSeconds(), new Object[0]).node("missing-cp-member-auto-removal-seconds", cpSubsystemConfig.getMissingCPMemberAutoRemovalSeconds(), new Object[0]).node("fail-on-indeterminate-operation-state", cpSubsystemConfig.isFailOnIndeterminateOperationState(), new Object[0]).node("persistence-enabled", cpSubsystemConfig.isPersistenceEnabled(), new Object[0]).node("base-dir", cpSubsystemConfig.getBaseDir().getAbsolutePath(), new Object[0]).node("data-load-timeout-seconds", cpSubsystemConfig.getDataLoadTimeoutSeconds(), new Object[0]);
        RaftAlgorithmConfig raftAlgorithmConfig = cpSubsystemConfig.getRaftAlgorithmConfig();
        gen.open("raft-algorithm", new Object[0]).node("leader-election-timeout-in-millis", raftAlgorithmConfig.getLeaderElectionTimeoutInMillis(), new Object[0]).node("leader-heartbeat-period-in-millis", raftAlgorithmConfig.getLeaderHeartbeatPeriodInMillis(), new Object[0]).node("max-missed-leader-heartbeat-count", raftAlgorithmConfig.getMaxMissedLeaderHeartbeatCount(), new Object[0]).node("append-request-max-entry-count", raftAlgorithmConfig.getAppendRequestMaxEntryCount(), new Object[0]).node("commit-index-advance-count-to-snapshot", raftAlgorithmConfig.getCommitIndexAdvanceCountToSnapshot(), new Object[0]).node("uncommitted-entry-count-to-reject-new-appends", raftAlgorithmConfig.getUncommittedEntryCountToRejectNewAppends(), new Object[0]).node("append-request-backoff-timeout-in-millis", raftAlgorithmConfig.getAppendRequestBackoffTimeoutInMillis(), new Object[0]).close();
        gen.open("semaphores", new Object[0]);
        for (SemaphoreConfig semaphoreConfig : cpSubsystemConfig.getSemaphoreConfigs().values()) {
            gen.open("semaphore", new Object[0]).node("name", semaphoreConfig.getName(), new Object[0]).node("jdk-compatible", semaphoreConfig.isJDKCompatible(), new Object[0]).node("initial-permits", semaphoreConfig.getInitialPermits(), new Object[0]).close();
        }
        gen.close().open("locks", new Object[0]);
        for (FencedLockConfig lockConfig : cpSubsystemConfig.getLockConfigs().values()) {
            gen.open("fenced-lock", new Object[0]).node("name", lockConfig.getName(), new Object[0]).node("lock-acquire-limit", lockConfig.getLockAcquireLimit(), new Object[0]).close();
        }
        gen.close().close();
    }

    private static void metricsConfig(XmlGenerator gen, Config config) {
        MetricsConfig metricsConfig = config.getMetricsConfig();
        gen.open("metrics", "enabled", metricsConfig.isEnabled()).open("management-center", "enabled", metricsConfig.getManagementCenterConfig().isEnabled()).node("retention-seconds", metricsConfig.getManagementCenterConfig().getRetentionSeconds(), new Object[0]).close().open("jmx", "enabled", metricsConfig.getJmxConfig().isEnabled()).close().node("collection-frequency-seconds", metricsConfig.getCollectionFrequencySeconds(), new Object[0]).close();
    }

    private static void userCodeDeploymentConfig(XmlGenerator gen, Config config) {
        UserCodeDeploymentConfig ucdConfig = config.getUserCodeDeploymentConfig();
        gen.open("user-code-deployment", "enabled", ucdConfig.isEnabled()).node("class-cache-mode", (Object)ucdConfig.getClassCacheMode(), new Object[0]).node("provider-mode", (Object)ucdConfig.getProviderMode(), new Object[0]).node("blacklist-prefixes", ucdConfig.getBlacklistedPrefixes(), new Object[0]).node("whitelist-prefixes", ucdConfig.getWhitelistedPrefixes(), new Object[0]).node("provider-filter", ucdConfig.getProviderFilter(), new Object[0]).close();
    }

    private static void handleSplitBrainProtectionFunction(XmlGenerator gen, SplitBrainProtectionConfig splitBrainProtectionConfig) {
        if (splitBrainProtectionConfig.getFunctionImplementation() instanceof ProbabilisticSplitBrainProtectionFunction) {
            ProbabilisticSplitBrainProtectionFunction qf = (ProbabilisticSplitBrainProtectionFunction)splitBrainProtectionConfig.getFunctionImplementation();
            long acceptableHeartbeatPause = qf.getAcceptableHeartbeatPauseMillis();
            double threshold = qf.getSuspicionThreshold();
            int maxSampleSize = qf.getMaxSampleSize();
            long minStdDeviation = qf.getMinStdDeviationMillis();
            long firstHeartbeatEstimate = qf.getHeartbeatIntervalMillis();
            gen.open("probabilistic-split-brain-protection", "acceptable-heartbeat-pause-millis", acceptableHeartbeatPause, "suspicion-threshold", threshold, "max-sample-size", maxSampleSize, "min-std-deviation-millis", minStdDeviation, "heartbeat-interval-millis", firstHeartbeatEstimate);
            gen.close();
        } else if (splitBrainProtectionConfig.getFunctionImplementation() instanceof RecentlyActiveSplitBrainProtectionFunction) {
            RecentlyActiveSplitBrainProtectionFunction qf = (RecentlyActiveSplitBrainProtectionFunction)splitBrainProtectionConfig.getFunctionImplementation();
            gen.open("recently-active-split-brain-protection", "heartbeat-tolerance-millis", qf.getHeartbeatToleranceMillis());
            gen.close();
        } else {
            gen.node("function-class-name", ConfigXmlGenerator.classNameOrImplClass(splitBrainProtectionConfig.getFunctionClassName(), splitBrainProtectionConfig.getFunctionImplementation()), new Object[0]);
        }
    }

    private static void nativeMemoryXmlGenerator(XmlGenerator gen, Config config) {
        NativeMemoryConfig nativeMemoryConfig = config.getNativeMemoryConfig();
        if (nativeMemoryConfig == null) {
            gen.node("native-memory", null, "enabled", "false");
            return;
        }
        gen.open("native-memory", new Object[]{"enabled", nativeMemoryConfig.isEnabled(), "allocator-type", nativeMemoryConfig.getAllocatorType()}).node("size", null, new Object[]{"unit", nativeMemoryConfig.getSize().getUnit(), "value", nativeMemoryConfig.getSize().getValue()}).node("min-block-size", nativeMemoryConfig.getMinBlockSize(), new Object[0]).node("page-size", nativeMemoryConfig.getPageSize(), new Object[0]).node("metadata-space-percentage", Float.valueOf(nativeMemoryConfig.getMetadataSpacePercentage()), new Object[0]).node("persistent-memory-directory", nativeMemoryConfig.getPersistentMemoryDirectory(), new Object[0]).close();
    }

    private static void liteMemberXmlGenerator(XmlGenerator gen, Config config) {
        gen.node("lite-member", null, "enabled", config.isLiteMember());
    }

    private static void restApiXmlGenerator(XmlGenerator gen, NetworkConfig config) {
        RestApiConfig c = config.getRestApiConfig();
        if (c == null) {
            return;
        }
        gen.open("rest-api", "enabled", c.isEnabled());
        for (RestEndpointGroup group : RestEndpointGroup.values()) {
            gen.node("endpoint-group", null, "name", group.name(), "enabled", c.isGroupEnabled(group));
        }
        gen.close();
    }

    private static void memcacheProtocolXmlGenerator(XmlGenerator gen, NetworkConfig config) {
        MemcacheProtocolConfig c = config.getMemcacheProtocolConfig();
        if (c == null) {
            return;
        }
        gen.node("memcache-protocol", null, "enabled", c.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(String input, int indent) {
        if (!this.formatted) {
            return input;
        }
        StreamResult xmlOutput = null;
        try {
            Transformer transformer;
            StreamSource xmlInput;
            block12: {
                TransformerFactory transformerFactory;
                block11: {
                    xmlInput = new StreamSource(new StringReader(input));
                    xmlOutput = new StreamResult(new StringWriter());
                    transformerFactory = TransformerFactory.newInstance();
                    try {
                        transformerFactory.setAttribute("indent-number", indent);
                    }
                    catch (IllegalArgumentException e) {
                        if (!LOGGER.isFinestEnabled()) break block11;
                        LOGGER.finest("Failed to set indent-number attribute; cause: " + e.getMessage());
                    }
                }
                transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
                }
                catch (IllegalArgumentException e) {
                    if (!LOGGER.isFinestEnabled()) break block12;
                    LOGGER.finest("Failed to set indent-amount property; cause: " + e.getMessage());
                }
            }
            transformer.transform(xmlInput, xmlOutput);
            String string = xmlOutput.getWriter().toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.warning(e);
            String string = input;
            return string;
        }
        finally {
            if (xmlOutput != null) {
                IOUtil.closeResource(xmlOutput.getWriter());
            }
        }
    }

    private static void appendItemListenerConfigs(XmlGenerator gen, Collection<ItemListenerConfig> configs) {
        if (CollectionUtil.isNotEmpty(configs)) {
            gen.open("item-listeners", new Object[0]);
            for (ItemListenerConfig lc : configs) {
                gen.node("item-listener", lc.getClassName(), "include-value", lc.isIncludeValue());
            }
            gen.close();
        }
    }

    private static void appendSerializationFactory(XmlGenerator gen, String elementName, Map<Integer, ?> factoryMap) {
        if (MapUtil.isNullOrEmpty(factoryMap)) {
            return;
        }
        for (Map.Entry<Integer, ?> factory : factoryMap.entrySet()) {
            Object value = factory.getValue();
            String className = value instanceof String ? (String)value : value.getClass().getName();
            gen.node(elementName, className, "factory-id", ((Object)factory.getKey()).toString());
        }
    }

    private static void appendFilterList(XmlGenerator gen, String listName, ClassFilter classFilterList) {
        if (classFilterList.isEmpty()) {
            return;
        }
        gen.open(listName, new Object[0]);
        for (String className : classFilterList.getClasses()) {
            gen.node("class", className, new Object[0]);
        }
        for (String packageName : classFilterList.getPackages()) {
            gen.node("package", packageName, new Object[0]);
        }
        for (String prefix : classFilterList.getPrefixes()) {
            gen.node("prefix", prefix, new Object[0]);
        }
        gen.close();
    }

    public static final class XmlGenerator {
        private static final int CAPACITY = 64;
        private final StringBuilder xml;
        private final ArrayDeque<String> openNodes = new ArrayDeque();

        public XmlGenerator(StringBuilder xml) {
            this.xml = xml;
        }

        public XmlGenerator open(String name, Object ... attributes) {
            XmlGenerator.appendOpenNode(this.xml, name, attributes);
            this.openNodes.addLast(name);
            return this;
        }

        public XmlGenerator node(String name, Object contents, Object ... attributes) {
            XmlGenerator.appendNode(this.xml, name, contents, attributes);
            return this;
        }

        public XmlGenerator nodeIfContents(String name, Object contents, Object ... attributes) {
            if (contents != null) {
                XmlGenerator.appendNode(this.xml, name, contents, attributes);
            }
            return this;
        }

        public XmlGenerator close() {
            XmlGenerator.appendCloseNode(this.xml, this.openNodes.pollLast());
            return this;
        }

        public XmlGenerator appendLabels(Set<String> labels) {
            if (!labels.isEmpty()) {
                this.open("client-labels", new Object[0]);
                for (String label : labels) {
                    this.node("label", label, new Object[0]);
                }
                this.close();
            }
            return this;
        }

        public XmlGenerator appendProperties(Properties props) {
            if (!props.isEmpty()) {
                this.open("properties", new Object[0]);
                Set<Object> keys = props.keySet();
                for (Object key : keys) {
                    this.node("property", props.getProperty(key.toString()), "name", key.toString());
                }
                this.close();
            }
            return this;
        }

        public XmlGenerator appendProperties(Map<String, ? extends Comparable> props) {
            if (!MapUtil.isNullOrEmpty(props)) {
                this.open("properties", new Object[0]);
                for (Map.Entry<String, ? extends Comparable> entry : props.entrySet()) {
                    this.node("property", entry.getValue(), "name", entry.getKey());
                }
                this.close();
            }
            return this;
        }

        private static void appendOpenNode(StringBuilder xml, String name, Object ... attributes) {
            xml.append('<').append(name);
            XmlGenerator.appendAttributes(xml, attributes);
            xml.append('>');
        }

        private static void appendCloseNode(StringBuilder xml, String name) {
            xml.append("</").append(name).append('>');
        }

        private static void appendNode(StringBuilder xml, String name, Object contents, Object ... attributes) {
            if (contents != null || attributes.length > 0) {
                xml.append('<').append(name);
                XmlGenerator.appendAttributes(xml, attributes);
                if (contents != null) {
                    xml.append('>');
                    XmlGenerator.escapeXml(contents, xml);
                    xml.append("</").append(name).append('>');
                } else {
                    xml.append("/>");
                }
            }
        }

        private static void appendAttributes(StringBuilder xml, Object ... attributes) {
            int i = 0;
            while (i < attributes.length) {
                Object attributeValue;
                Object attributeName = attributes[i++];
                if ((attributeValue = attributes[i++]) == null) continue;
                xml.append(" ").append(attributeName).append("=\"");
                XmlGenerator.escapeXmlAttr(attributeValue, xml);
                xml.append("\"");
            }
        }

        private static void escapeXml(Object o, StringBuilder appendTo) {
            if (o == null) {
                appendTo.append("null");
                return;
            }
            String s = o.toString();
            int length = s.length();
            appendTo.ensureCapacity(appendTo.length() + length + 64);
            for (int i = 0; i < length; ++i) {
                char ch = s.charAt(i);
                if (ch == '<') {
                    appendTo.append("&lt;");
                    continue;
                }
                if (ch == '&') {
                    appendTo.append("&amp;");
                    continue;
                }
                appendTo.append(ch);
            }
        }

        private static void escapeXmlAttr(Object o, StringBuilder appendTo) {
            if (o == null) {
                appendTo.append("null");
                return;
            }
            String s = o.toString();
            int length = s.length();
            appendTo.ensureCapacity(appendTo.length() + length + 64);
            block6: for (int i = 0; i < length; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        appendTo.append("&quot;");
                        continue block6;
                    }
                    case '\'': {
                        appendTo.append("&#39;");
                        continue block6;
                    }
                    case '&': {
                        appendTo.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        appendTo.append("&lt;");
                        continue block6;
                    }
                    default: {
                        appendTo.append(ch);
                    }
                }
            }
        }
    }
}

