/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.exception.CPGroupDestroyedException;
import com.hazelcast.cp.exception.NotLeaderException;
import com.hazelcast.cp.internal.IndeterminateOperationStateAware;
import com.hazelcast.cp.internal.RaftNodeAware;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.RaftSystemOperation;
import com.hazelcast.cp.internal.raft.QueryPolicy;
import com.hazelcast.cp.internal.raft.impl.RaftNode;
import com.hazelcast.cp.internal.raft.impl.RaftNodeStatus;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.function.BiConsumer;

public class RaftQueryOp
extends Operation
implements IndeterminateOperationStateAware,
RaftSystemOperation,
BiConsumer<Object, Throwable>,
IdentifiedDataSerializable {
    private CPGroupId groupId;
    private QueryPolicy queryPolicy;
    private Object op;

    public RaftQueryOp() {
    }

    public RaftQueryOp(CPGroupId groupId, RaftOp raftOp, QueryPolicy queryPolicy) {
        this.groupId = groupId;
        this.op = raftOp;
        this.queryPolicy = queryPolicy;
    }

    @Override
    public final void run() {
        RaftService service = (RaftService)this.getService();
        RaftNode raftNode = service.getRaftNode(this.groupId);
        if (raftNode == null) {
            if (service.isRaftGroupDestroyed(this.groupId)) {
                this.sendResponse(new CPGroupDestroyedException(this.groupId));
            } else {
                this.sendResponse(new NotLeaderException(this.groupId, service.getLocalCPEndpoint(), null));
            }
            return;
        }
        if (raftNode.getStatus() == RaftNodeStatus.STEPPED_DOWN) {
            this.sendResponse(new NotLeaderException(this.groupId, service.getLocalCPEndpoint(), null));
            this.getNodeEngine().getExecutionService().execute("hz:cpSubsystem", () -> service.stepDownRaftNode(this.groupId));
            return;
        }
        if (this.op instanceof RaftNodeAware) {
            ((RaftNodeAware)this.op).setRaftNode(raftNode);
        }
        raftNode.query(this.op, this.queryPolicy).whenCompleteAsync((BiConsumer)this, ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    public boolean isRetryableOnIndeterminateOperationState() {
        return true;
    }

    @Override
    public void accept(Object o, Throwable throwable) {
        if (throwable == null) {
            this.sendResponse(o);
        } else {
            this.sendResponse(throwable);
        }
    }

    @Override
    public final boolean returnsResponse() {
        return false;
    }

    @Override
    public final boolean validatesTarget() {
        return false;
    }

    @Override
    public final String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 20;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.groupId);
        out.writeObject(this.op);
        out.writeUTF(this.queryPolicy.toString());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.groupId = (CPGroupId)in.readObject();
        this.op = in.readObject();
        this.queryPolicy = QueryPolicy.valueOf(in.readUTF());
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", op=").append(this.op).append(", groupId=").append(this.groupId).append(", policy=").append((Object)this.queryPolicy);
    }
}

