/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.fasterxml.jackson.jr.ob.impl;

import com.hazelcast.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.com.fasterxml.jackson.core.JsonToken;
import com.hazelcast.com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.hazelcast.com.fasterxml.jackson.jr.ob.api.ValueReader;
import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.JSONReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public class SimpleValueReader
extends ValueReader {
    protected final int _typeId;

    public SimpleValueReader(Class<?> clazz, int n) {
        super(clazz);
        this._typeId = n;
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        switch (this._typeId) {
            case 9: 
            case 10: {
                return this._nextString(jsonParser);
            }
            case 11: {
                String string = this._nextString(jsonParser);
                return string == null ? null : string.toCharArray();
            }
            case 14: {
                return (short)this._nextInt(jsonParser);
            }
            case 15: {
                return this._nextInt(jsonParser);
            }
            case 16: {
                return this._nextLong(jsonParser);
            }
            case 21: {
                Boolean bl = jsonParser.nextBooleanValue();
                if (bl != null) {
                    return bl;
                }
                return jsonParser.getValueAsBoolean();
            }
        }
        jsonParser.nextToken();
        return this.read(jSONReader, jsonParser);
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        switch (this._typeId) {
            case 5: {
                return this._readIntArray(jsonParser);
            }
            case 8: {
                return jSONReader.readTree();
            }
            case 9: 
            case 10: {
                return jsonParser.getValueAsString();
            }
            case 11: {
                return jsonParser.getValueAsString().toCharArray();
            }
            case 12: {
                return this._readBinary(jsonParser);
            }
            case 17: {
                return Float.valueOf((float)jsonParser.getValueAsDouble());
            }
            case 18: {
                return jsonParser.getValueAsDouble();
            }
            case 13: {
                return (byte)jsonParser.getValueAsInt();
            }
            case 14: {
                return (short)jsonParser.getValueAsInt();
            }
            case 15: {
                return jsonParser.getValueAsInt();
            }
            case 16: {
                return jsonParser.getValueAsLong();
            }
            case 20: {
                return jsonParser.getDecimalValue();
            }
            case 19: {
                return jsonParser.getBigIntegerValue();
            }
            case 21: {
                return jsonParser.getValueAsBoolean();
            }
            case 22: {
                String string = jsonParser.getValueAsString();
                return Character.valueOf(string == null || string.isEmpty() ? (char)' ' : string.charAt(0));
            }
            case 25: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                long l = this._fetchLong(jsonParser);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l);
                return calendar;
            }
            case 24: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return new Date(this._fetchLong(jsonParser));
            }
            case 26: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                String string = jsonParser.getValueAsString();
                try {
                    return Class.forName(string);
                }
                catch (Exception exception) {
                    throw new JSONObjectException("Failed to bind java.lang.Class from value '" + string + "'");
                }
            }
            case 27: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return new File(jsonParser.getValueAsString());
            }
            case 28: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return UUID.fromString(jsonParser.getValueAsString());
            }
            case 29: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return new URL(jsonParser.getValueAsString());
            }
            case 30: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return URI.create(jsonParser.getValueAsString());
            }
        }
        throw JSONObjectException.from(jsonParser, "Can not create a " + this._valueType.getName() + " instance out of " + SimpleValueReader._tokenDesc(jsonParser));
    }

    protected byte[] _readBinary(JsonParser jsonParser) throws IOException {
        return jsonParser.getBinaryValue();
    }

    protected int[] _readIntArray(JsonParser jsonParser) throws IOException {
        throw new JSONObjectException("Reading of int[] not yet implemented");
    }

    protected long _fetchLong(JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return jsonParser.getLongValue();
        }
        throw JSONObjectException.from(jsonParser, "Can not get long numeric value from JSON (to construct " + this._valueType.getName() + ") from " + SimpleValueReader._tokenDesc(jsonParser, jsonToken));
    }

    private final String _nextString(JsonParser jsonParser) throws IOException {
        String string = jsonParser.nextTextValue();
        return string == null ? jsonParser.getValueAsString() : string;
    }

    private final int _nextInt(JsonParser jsonParser) throws IOException {
        int n = jsonParser.nextIntValue(-2);
        if (n != -2) {
            return n;
        }
        return jsonParser.getValueAsInt();
    }

    private final long _nextLong(JsonParser jsonParser) throws IOException {
        long l = jsonParser.nextLongValue(-2L);
        if (l != -2L) {
            return l;
        }
        return jsonParser.getValueAsLong();
    }
}

