/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ascii;

import com.hazelcast.internal.ascii.CommandParser;
import com.hazelcast.internal.ascii.rest.HttpDeleteCommandParser;
import com.hazelcast.internal.ascii.rest.HttpGetCommandParser;
import com.hazelcast.internal.ascii.rest.HttpHeadCommandParser;
import com.hazelcast.internal.ascii.rest.HttpPostCommandParser;
import com.hazelcast.internal.nio.IOService;
import com.hazelcast.internal.nio.ascii.RestApiFilter;
import com.hazelcast.internal.nio.ascii.TextDecoder;
import com.hazelcast.internal.nio.ascii.TextEncoder;
import com.hazelcast.internal.nio.ascii.TextParsers;
import com.hazelcast.internal.nio.tcp.TcpIpConnection;
import java.util.HashMap;

public class RestApiTextDecoder
extends TextDecoder {
    public static final TextParsers TEXT_PARSERS;

    public RestApiTextDecoder(TcpIpConnection connection, TextEncoder encoder, boolean rootDecoder) {
        super(connection, encoder, RestApiTextDecoder.createFilter(connection), TEXT_PARSERS, rootDecoder);
    }

    private static RestApiFilter createFilter(TcpIpConnection connection) {
        IOService ioService = connection.getEndpointManager().getNetworkingService().getIoService();
        return new RestApiFilter(ioService.getLoggingService(), ioService.getRestApiConfig(), TEXT_PARSERS);
    }

    static {
        HashMap<String, CommandParser> parsers = new HashMap<String, CommandParser>();
        parsers.put("GET", new HttpGetCommandParser());
        parsers.put("POST", new HttpPostCommandParser());
        parsers.put("PUT", new HttpPostCommandParser());
        parsers.put("DELETE", new HttpDeleteCommandParser());
        parsers.put("HEAD", new HttpHeadCommandParser());
        TEXT_PARSERS = new TextParsers(parsers);
    }
}

