/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Cluster;
import com.hazelcast.collection.IList;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.JetCacheManager;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobAlreadyExistsException;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.JetCacheManagerImpl;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.observer.ObservableImpl;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.topic.ITopic;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class AbstractJetInstance
implements JetInstance {
    private final HazelcastInstance hazelcastInstance;
    private final JetCacheManagerImpl cacheManager;
    private final Supplier<JobRepository> jobRepository;
    private final Map<String, Observable> observables = new ConcurrentHashMap<String, Observable>();

    public AbstractJetInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
        this.cacheManager = new JetCacheManagerImpl(this);
        this.jobRepository = Util.memoizeConcurrent(() -> new JobRepository(this));
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
        long jobId = this.uploadResourcesAndAssignId(config);
        return this.newJobProxy(jobId, dag, config);
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        config = config.attachAll(((PipelineImpl)pipeline).attachedFiles());
        long jobId = this.uploadResourcesAndAssignId(config);
        return this.newJobProxy(jobId, pipeline, config);
    }

    private Job newJobInt(@Nonnull Object jobDefinition, @Nonnull JobConfig config) {
        if (jobDefinition instanceof PipelineImpl) {
            return this.newJob((PipelineImpl)jobDefinition, config);
        }
        return this.newJob((DAG)jobDefinition, config);
    }

    private Job newJobIfAbsent(@Nonnull Object jobDefinition, @Nonnull JobConfig config) {
        if (config.getName() == null) {
            return this.newJobInt(jobDefinition, config);
        }
        JobStatus status;
        Job job;
        while ((job = this.getJob(config.getName())) == null || (status = job.getStatus()) == JobStatus.FAILED || status == JobStatus.COMPLETED) {
            try {
                return this.newJobInt(jobDefinition, config);
            }
            catch (JobAlreadyExistsException e) {
                LoggingUtil.logFine(this.getLogger(), "Could not submit job with duplicate name: %s, ignoring", config.getName());
                continue;
            }
            break;
        }
        return job;
    }

    @Override
    @Nonnull
    public Job newJobIfAbsent(@Nonnull DAG dag, @Nonnull JobConfig config) {
        return this.newJobIfAbsent((Object)dag, config);
    }

    @Override
    @Nonnull
    public Job newJobIfAbsent(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        return this.newJobIfAbsent((Object)pipeline, config);
    }

    @Override
    public Job getJob(long jobId) {
        try {
            Job job = this.newJobProxy(jobId);
            job.getStatus();
            return job;
        }
        catch (Throwable t) {
            if (ExceptionUtil.peel(t) instanceof JobNotFoundException) {
                return null;
            }
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    @Nonnull
    public List<Job> getJobs(@Nonnull String name) {
        return Util.toList(this.getJobIdsByName(name), this::newJobProxy);
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.getHazelcastInstance().getCluster();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.hazelcastInstance.getName();
    }

    @Override
    @Nonnull
    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        return this.hazelcastInstance.getMap(name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        return this.hazelcastInstance.getReplicatedMap(name);
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        return this.hazelcastInstance.getList(name);
    }

    @Nonnull
    public <T> ITopic<T> getReliableTopic(@Nonnull String name) {
        return this.hazelcastInstance.getReliableTopic(name);
    }

    @Override
    @Nonnull
    public JetCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    @Nonnull
    public <T> Observable<T> getObservable(@Nonnull String name) {
        return this.observables.computeIfAbsent(name, observableName -> new ObservableImpl((String)observableName, this.hazelcastInstance, this::onDestroy, this.getLogger()));
    }

    @Override
    @Nonnull
    public Collection<Observable<?>> getObservables() {
        return this.hazelcastInstance.getDistributedObjects().stream().filter(o -> o.getServiceName().equals("hz:impl:ringbufferService")).filter(o -> o.getName().startsWith("__jet.observables.")).map(o -> o.getName().substring("__jet.observables.".length())).map(this::getObservable).collect(Collectors.toList());
    }

    @Override
    public void shutdown() {
        this.hazelcastInstance.shutdown();
    }

    private void onDestroy(Observable<?> observable) {
        this.observables.remove(observable.name());
    }

    public abstract boolean existsDistributedObject(@Nonnull String var1, @Nonnull String var2);

    private long uploadResourcesAndAssignId(JobConfig config) {
        return this.jobRepository.get().uploadJobResources(config);
    }

    public abstract ILogger getLogger();

    public abstract Job newJobProxy(long var1);

    public abstract Job newJobProxy(long var1, Object var3, JobConfig var4);

    public abstract List<Long> getJobIdsByName(String var1);
}

