/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.processor;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BinaryOperatorEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.connector.HazelcastWriters;
import com.hazelcast.jet.impl.connector.WriteBufferedP;
import com.hazelcast.jet.impl.connector.WriteFileP;
import com.hazelcast.jet.impl.connector.WriteJdbcP;
import com.hazelcast.jet.impl.connector.WriteJmsP;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.EntryProcessor;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.Session;
import javax.sql.CommonDataSource;

public final class SinkProcessors {
    private SinkProcessors() {
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier writeMapP(@Nonnull String mapName) {
        return SinkProcessors.writeMapP(mapName, Map.Entry::getKey, Map.Entry::getValue);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier writeMapP(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn) {
        return HazelcastWriters.writeMapSupplier(mapName, null, toKeyFn, toValueFn);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return SinkProcessors.writeRemoteMapP(mapName, clientConfig, FunctionEx.identity(), FunctionEx.identity());
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier writeRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn) {
        return HazelcastWriters.writeMapSupplier(mapName, clientConfig, toKeyFn, toValueFn);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier mergeMapP(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull BinaryOperatorEx<V> mergeFn) {
        return HazelcastWriters.mergeMapSupplier(mapName, null, toKeyFn, toValueFn, mergeFn);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier mergeRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull BinaryOperatorEx<V> mergeFn) {
        return HazelcastWriters.mergeMapSupplier(mapName, clientConfig, toKeyFn, toValueFn, mergeFn);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier updateMapP(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        return HazelcastWriters.updateMapSupplier(mapName, null, toKeyFn, updateFn);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier updateRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        return HazelcastWriters.updateMapSupplier(mapName, clientConfig, toKeyFn, updateFn);
    }

    @Nonnull
    public static <T, K, V, R> ProcessorMetaSupplier updateMapP(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        return HazelcastWriters.updateMapSupplier(mapName, null, toKeyFn, toEntryProcessorFn);
    }

    @Nonnull
    public static <T, K, V, R> ProcessorMetaSupplier updateMapP(int maxParallelAsyncOps, @Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        return HazelcastWriters.updateMapSupplier(maxParallelAsyncOps, mapName, null, toKeyFn, toEntryProcessorFn);
    }

    @Nonnull
    public static <T, K, V, R> ProcessorMetaSupplier updateRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        return HazelcastWriters.updateMapSupplier(mapName, clientConfig, toKeyFn, toEntryProcessorFn);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeCacheP(@Nonnull String cacheName) {
        return HazelcastWriters.writeCacheSupplier(cacheName, null);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return HazelcastWriters.writeCacheSupplier(cacheName, clientConfig);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeListP(@Nonnull String listName) {
        return HazelcastWriters.writeListSupplier(listName, null);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeRemoteListP(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return HazelcastWriters.writeListSupplier(listName, clientConfig);
    }

    public static <T> ProcessorMetaSupplier writeSocketP(@Nonnull String host, int port, @Nonnull FunctionEx<? super T, ? extends String> toStringFn, @Nonnull Charset charset) {
        Util.checkSerializable(toStringFn, "toStringFn");
        String charsetName = charset.name();
        return ProcessorMetaSupplier.preferLocalParallelismOne(SinkProcessors.writeBufferedP(index -> new BufferedWriter(new OutputStreamWriter(new Socket(host, port).getOutputStream(), charsetName)), (bufferedWriter, item) -> {
            Object t = item;
            bufferedWriter.write((String)toStringFn.apply(t));
            bufferedWriter.write(10);
        }, BufferedWriter::flush, BufferedWriter::close));
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier writeFileP(@Nonnull String directoryName, @Nonnull Charset charset, @Nullable String datePattern, long maxFileSize, boolean exactlyOnce, @Nonnull FunctionEx<? super T, ? extends String> toStringFn) {
        Util.checkSerializable(toStringFn, "toStringFn");
        return WriteFileP.metaSupplier(directoryName, toStringFn, charset.name(), datePattern, maxFileSize, exactlyOnce);
    }

    @Nonnull
    public static <W, T> SupplierEx<Processor> writeBufferedP(@Nonnull FunctionEx<? super Processor.Context, ? extends W> createFn, @Nonnull BiConsumerEx<? super W, ? super T> onReceiveFn, @Nonnull ConsumerEx<? super W> flushFn) {
        return SinkProcessors.writeBufferedP(createFn, onReceiveFn, flushFn, ConsumerEx.noop());
    }

    @Nonnull
    public static <W, T> SupplierEx<Processor> writeBufferedP(@Nonnull FunctionEx<? super Processor.Context, ? extends W> createFn, @Nonnull BiConsumerEx<? super W, ? super T> onReceiveFn, @Nonnull ConsumerEx<? super W> flushFn, @Nonnull ConsumerEx<? super W> destroyFn) {
        return WriteBufferedP.supplier(createFn, onReceiveFn, flushFn, destroyFn);
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier writeJmsQueueP(@Nonnull String queueName, boolean exactlyOnce, @Nonnull SupplierEx<? extends Connection> newConnectionFn, @Nonnull BiFunctionEx<? super Session, ? super T, ? extends Message> messageFn) {
        return WriteJmsP.supplier(queueName, exactlyOnce, newConnectionFn, messageFn, false);
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier writeJmsTopicP(@Nonnull String topicName, boolean exactlyOnce, @Nonnull SupplierEx<? extends Connection> newConnectionFn, @Nonnull BiFunctionEx<? super Session, ? super T, ? extends Message> messageFn) {
        return WriteJmsP.supplier(topicName, exactlyOnce, newConnectionFn, messageFn, true);
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier writeJdbcP(@Nonnull String updateQuery, @Nonnull SupplierEx<? extends CommonDataSource> dataSourceSupplier, @Nonnull BiConsumerEx<? super PreparedStatement, ? super T> bindFn, boolean exactlyOnce) {
        Preconditions.checkNotNull(updateQuery, "updateQuery");
        Preconditions.checkNotNull(dataSourceSupplier, "dataSourceSupplier");
        Preconditions.checkNotNull(bindFn, "bindFn");
        return WriteJdbcP.metaSupplier(updateQuery, dataSourceSupplier, bindFn, exactlyOnce);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeObservableP(@Nonnull String name) {
        return HazelcastWriters.writeObservableSupplier(name);
    }
}

