/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;

public class SnapshotPhase1Operation
extends AsyncJobOperation {
    public static volatile boolean postponeResponses;
    private static final int RETRY_MS = 100;
    private long executionId;
    private long snapshotId;
    private String mapName;
    private int flags;

    public SnapshotPhase1Operation() {
    }

    public SnapshotPhase1Operation(long jobId, long executionId, long snapshotId, String mapName, int flags) {
        super(jobId);
        this.executionId = executionId;
        this.snapshotId = snapshotId;
        this.mapName = mapName;
        this.flags = flags;
    }

    protected CompletableFuture<SnapshotPhase1Result> doRun() {
        JetService service = (JetService)this.getService();
        ExecutionContext ctx = service.getJobExecutionService().assertExecutionContext(this.getCallerAddress(), this.jobId(), this.executionId, this.getClass().getSimpleName());
        CompletionStage future = ((CompletableFuture)ctx.beginSnapshotPhase1(this.snapshotId, this.mapName, this.flags).exceptionally(exc -> new SnapshotPhase1Result(0L, 0L, 0L, (Throwable)exc))).thenApply(result -> {
            if (result.getError() == null) {
                LoggingUtil.logFine(this.getLogger(), "Snapshot %s phase 1 for %s finished successfully on member", this.snapshotId, ctx.jobNameAndExecutionId());
            } else {
                this.getLogger().warning(String.format("Snapshot %d phase 1 for %s finished with an error on member: %s", this.snapshotId, ctx.jobNameAndExecutionId(), result.getError()));
            }
            return result;
        });
        if (!postponeResponses) {
            return future;
        }
        return ((CompletableFuture)future).thenCompose(result -> {
            CompletableFuture<SnapshotPhase1Result> f2 = new CompletableFuture<SnapshotPhase1Result>();
            this.tryCompleteLater((SnapshotPhase1Result)result, f2);
            return f2;
        });
    }

    private void tryCompleteLater(SnapshotPhase1Result result, CompletableFuture<SnapshotPhase1Result> future) {
        this.getNodeEngine().getExecutionService().schedule(() -> {
            if (postponeResponses) {
                this.tryCompleteLater(result, future);
            } else {
                future.complete(result);
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeLong(this.snapshotId);
        out.writeUTF(this.mapName);
        out.writeInt(this.flags);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.snapshotId = in.readLong();
        this.mapName = in.readUTF();
        this.flags = in.readInt();
    }

    public static final class SnapshotPhase1Result
    implements IdentifiedDataSerializable {
        private long numBytes;
        private long numKeys;
        private long numChunks;
        private String error;

        public SnapshotPhase1Result() {
        }

        public SnapshotPhase1Result(long numBytes, long numKeys, long numChunks, Throwable error) {
            this.numBytes = numBytes;
            this.numKeys = numKeys;
            this.numChunks = numChunks;
            this.error = error == null ? null : Objects.requireNonNull(error.toString());
        }

        public long getNumBytes() {
            return this.numBytes;
        }

        public long getNumKeys() {
            return this.numKeys;
        }

        public long getNumChunks() {
            return this.numChunks;
        }

        public String getError() {
            return this.error;
        }

        public void merge(SnapshotPhase1Result other) {
            this.numBytes += other.numBytes;
            this.numKeys += other.numKeys;
            this.numChunks += other.numChunks;
            if (this.error == null) {
                this.error = other.error;
            }
        }

        public String toString() {
            return "SnapshotOperationResult{numBytes=" + this.numBytes + ", numKeys=" + this.numKeys + ", numChunks=" + this.numChunks + ", error=" + this.error + '}';
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 25;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeLong(this.numBytes);
            out.writeLong(this.numKeys);
            out.writeLong(this.numChunks);
            out.writeUTF(this.error);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.numBytes = in.readLong();
            this.numKeys = in.readLong();
            this.numChunks = in.readLong();
            this.error = in.readUTF();
        }
    }
}

